/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.mapattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Department;
import ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Employee;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_metamodelapi_mapattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getJavaKeyType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Class javaKeyType = mapAttrib.getKeyJavaType();
                if (javaKeyType.getName().equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Map Attribute's Java Key Type  = " + javaKeyType.getName());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Map Attribute's Java Key Type  = " + javaKeyType.getName());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaKeyType Test  failed");
        }
    }

    @Test
    public void getKeyType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Type keyType = mapAttrib.getKeyType();
                String javaKeyTypeName = keyType.getJavaType().getName();
                if (javaKeyTypeName.equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Map Attribute's Java Key Type  = " + javaKeyTypeName);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Map Attribute's Java Key Type  = " + javaKeyTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getKeyType Test  failed");
        }
    }

    @Test
    public void getCollectionType() throws Exception {
        boolean pass = false;
        String expected = PluralAttribute.CollectionType.MAP.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                PluralAttribute.CollectionType type = mapAttrib.getCollectionType();
                if (type != null) {
                    String name = type.name();
                    if (name.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result: " + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + expected + ", actual: " + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollectionType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    @Test
    public void getElementType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.mapattribute.Employee";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Department.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                Type type = mapAttrib.getElementType();
                if (type != null) {
                    String name = type.getJavaType().getName();
                    if (name.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result: " + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + expected + ", actual: " + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

