/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.type;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.type.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.type.Order;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "Order", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_type.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getPersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Type.PersistenceType type = mTypeOrder.getPersistenceType();
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                if (type.equals((Object)Type.PersistenceType.ENTITY)) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Persistence type = " + type.name());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType Test  failed");
        }
    }

    @Test
    public void getEmbeddablePersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eTypeAddress = metaModel.embeddable(Address.class);
            if (eTypeAddress != null) {
                Type.PersistenceType type = eTypeAddress.getPersistenceType();
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Embeddable Type");
                if (type.equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Persistence type = " + type);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEmbeddablePersistenceType Test  failed");
        }
    }

    @Test
    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Class javaType = mTypeOrder.getJavaType();
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                if (javaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.type.Order")) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "javaType name = " + javaType.getName());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

