/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.cache.xml.all;

import ee.jakarta.tck.persistence.common.DriverManagerConnection;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.cache.xml.all.Order;
import jakarta.persistence.Cache;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Properties jpaprops = new Properties();

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "Order"};
        return this.createDeploymentJar("jpa_se_cache_xml_all.jar", pkgNameWithoutSuffix, classes, "persistence.xml", xmlFile);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.jpaprops.putAll((Map<?, ?>)this.myProps);
            this.jpaprops.put("Insert_Jpa_Purchase_Order", System.getProperty("Insert_Jpa_Purchase_Order"));
            this.jpaprops.put("Select_Jpa_Purchase_Order", System.getProperty("Select_Jpa_Purchase_Order"));
            this.displayMap(this.jpaprops);
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void containsTest() throws Exception {
        boolean pass;
        block8: {
            pass = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Order order = new Order(1, 101);
                    em2.persist((Object)order);
                    logger.log(System.Logger.Level.TRACE, "persisted order " + order);
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache contains order " + order);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                        }
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass = true;
            }
        }
        if (!pass) {
            throw new Exception("containsTest failed");
        }
    }

    @Test
    public void cacheStoreModeBYPASSTest() throws Exception {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    logger.log(System.Logger.Level.TRACE, "persisted order " + order);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    logger.log(System.Logger.Level.TRACE, "Verify the order persisted successfully, but it is not in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order " + order);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        logger.log(System.Logger.Level.TRACE, "Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Entity was not persisted correctly - expected:" + order + ", actual:" + order2);
                    }
                    logger.log(System.Logger.Level.TRACE, "Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                            pass3 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order " + order);
                        }
                        break block14;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("cacheStoreModeBYPASSTest failed");
        }
    }

    @Test
    public void cacheStoreModeUSETest() throws Exception {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    logger.log(System.Logger.Level.TRACE, "persisted order " + order);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    logger.log(System.Logger.Level.TRACE, "Verify the order persisted successfully, and it is in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does contain order " + order);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        logger.log(System.Logger.Level.TRACE, "Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Entity was not persisted correctly - expected:" + order + ", actual:" + order2);
                    }
                    logger.log(System.Logger.Level.TRACE, "Find the order and verify it is loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does contain order " + order);
                            pass3 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                        }
                        break block14;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("cacheStoreModeUSETest failed");
        }
    }

    @Test
    public void cacheStoreModeREFRESHTest() throws Exception {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.REFRESH);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    logger.log(System.Logger.Level.TRACE, "persisted order " + order);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    logger.log(System.Logger.Level.TRACE, "Verify the order persisted successfully, and it is in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does contain order " + order);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        logger.log(System.Logger.Level.TRACE, "Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Entity was not persisted correctly - expected:" + order + ", actual:" + order2);
                    }
                    logger.log(System.Logger.Level.TRACE, "Find the order and verify it is loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does contain order " + order);
                            pass3 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                        }
                        break block14;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("cacheStoreModeREFRESHTest failed");
        }
    }

    @Test
    public void cacheRetrieveModeBYPASSTest() throws Exception {
        boolean pass1;
        boolean pass2;
        block12: {
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Persist an order");
                    this.createDataVIAJDBC(this.jpaprops);
                    logger.log(System.Logger.Level.TRACE, "Verify order is not in Cache before executing find");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order ");
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order ");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                    }
                    logger.log(System.Logger.Level.TRACE, "Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().setProperty("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = (Order)this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order " + order);
                        }
                        break block12;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass2 = true;
                pass1 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("cacheRetrieveModeBYPASSTest failed");
        }
    }

    @Test
    public void cacheRetrieveModeUSETest() throws Exception {
        boolean pass1;
        boolean pass2;
        block12: {
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Persist an order");
                    this.createDataVIAJDBC(this.jpaprops);
                    logger.log(System.Logger.Level.TRACE, "Verify order is not in Cache before executing find");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order ");
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order ");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                    }
                    logger.log(System.Logger.Level.TRACE, "Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().setProperty("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = (Order)this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b + ", therefore cache does not contain order " + order);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b + ", therefore cache does contain order " + order);
                        }
                        break block12;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass2 = true;
                pass1 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("cacheRetrieveModeUSETest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] selectDataVIAJDBC(Properties p, int id) {
        int[] params;
        block20: {
            params = new int[2];
            this.displayMap(p);
            Connection conn = null;
            try {
                DriverManagerConnection dmCon = new DriverManagerConnection();
                conn = dmCon.getConnection(p);
                String selectString = p.getProperty("Select_Jpa_Purchase_Order", "");
                logger.log(System.Logger.Level.TRACE, "ASDF:" + selectString);
                PreparedStatement pStmt = conn.prepareStatement(selectString);
                pStmt.setInt(1, id);
                logger.log(System.Logger.Level.TRACE, "SQL to be executed:" + pStmt.toString());
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    params[0] = rs.getInt(1);
                    params[1] = rs.getInt(2);
                    break block20;
                }
                throw new SQLException("Data not found");
            }
            catch (SQLException sqlex) {
                logger.log(System.Logger.Level.ERROR, "Received SQLException", (Throwable)sqlex);
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(System.Logger.Level.ERROR, "Received ClassNotFoundException", (Throwable)cnfe);
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received Exception", (Throwable)ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (Exception sqlex) {}
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataVIAJDBC(Properties p) {
        Connection conn = null;
        try {
            DriverManagerConnection dmCon = new DriverManagerConnection();
            conn = dmCon.getConnection(p);
            String insertString = p.getProperty("Insert_Jpa_Purchase_Order", "");
            PreparedStatement pStmt = conn.prepareStatement(insertString);
            pStmt.setInt(1, 1);
            pStmt.setInt(2, 101);
            logger.log(System.Logger.Level.TRACE, "SQL to be executed:" + pStmt.toString());
            int rows = pStmt.executeUpdate();
            logger.log(System.Logger.Level.TRACE, "Row inserted:" + rows);
        }
        catch (SQLException sqlex) {
            logger.log(System.Logger.Level.ERROR, "Received SQLException", (Throwable)sqlex);
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(System.Logger.Level.ERROR, "Received ClassNotFoundException", (Throwable)cnfe);
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received Exception", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception sqlex) {}
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

