/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client;

import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import ee.jakarta.tck.pages.common.client.BaseUrlClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractUrlClient
extends BaseUrlClient {
    private static final System.Logger logger = System.getLogger(AbstractUrlClient.class.getName());
    @ArquillianResource
    @OperateOnDeployment(value="_DEFAULT_")
    public URL url;
    protected static final String APITEST = "apitest";
    protected static final String APITEST1 = "apitest1";
    private static final String PASSED = "Test PASSED";
    private static final String FAILED = "Test FAILED";
    private String _jspName = null;
    protected InputStream goldenFileStream = null;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public InputStream getGoldenFileStream() {
        return this.goldenFileStream;
    }

    public void setGoldenFileStream(InputStream gfStream) {
        this.goldenFileStream = gfStream;
    }

    @Override
    protected void setTestProperties(WebTestCase testCase) {
        this.setStandardProperties(TEST_PROPS.getProperty("standard"), testCase);
        this.setGoldenFileStreamProperty(testCase, this.goldenFileStream);
        this.setApiTestProperties(TEST_PROPS.getProperty(APITEST), testCase);
        this.setApiTest1Properties(TEST_PROPS.getProperty(APITEST1), testCase);
        super.setTestProperties(testCase);
    }

    private void setGoldenFileStreamProperty(WebTestCase testCase, InputStream gfStream) {
        testCase.setGoldenFileStream(gfStream);
    }

    protected boolean isNullOrEmpty(String val) {
        return val == null || val.equals("");
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.INFO, "setup method AbstractUrlClient");
        if (this.url == null) {
            throw new Exception("[AbstractUrlClient] The url was not injected");
        }
        String hostname = this.url.getHost();
        String portnum = Integer.toString(this.url.getPort());
        Assertions.assertFalse((boolean)this.isNullOrEmpty(hostname), (String)"[AbstractUrlClient] 'webServerHost' was not set.");
        this._hostname = hostname.trim();
        Assertions.assertFalse((boolean)this.isNullOrEmpty(portnum), (String)"[AbstractUrlClient] 'webServerPort' was not set.");
        this._port = Integer.parseInt(portnum.trim());
        logger.log(System.Logger.Level.INFO, "[AbstractUrlClient] Test setup OK");
    }

    public void setTestJsp(String jsp) {
        this._jspName = jsp;
    }

    private void setApiTest1Properties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        String request = AbstractUrlClient.getApiTestRequest(this._contextRoot, this._jspName, testValue);
        HttpRequest req = new HttpRequest(request, this._hostname, this._port);
        testCase.setRequest(req);
    }

    private void setApiTestProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        String request = AbstractUrlClient.getApiTestRequest(this._contextRoot, this._jspName, testValue);
        HttpRequest req = new HttpRequest(request, this._hostname, this._port);
        testCase.setRequest(req);
        testCase.setResponseSearchString(PASSED);
        testCase.setUnexpectedResponseSearchString(FAILED);
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        sb.append("GET ").append(this._contextRoot).append("/");
        sb.append(testValue).append(".jsp").append(" HTTP/1.0");
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
        sb = new StringBuffer(50);
        sb.append(this._tsHome).append(this.GOLDENFILEDIR);
        sb.append(this._generalURI).append("/");
        sb.append(testValue).append(".gf");
        testCase.setGoldenFilePath(sb.toString());
    }

    private static String getApiTestRequest(String contextRoot, String jspName, String testName) {
        StringBuffer sb = new StringBuffer(50);
        sb.append("GET ").append(contextRoot).append("/");
        sb.append(jspName).append(".jsp").append("?testname=");
        sb.append(testName).append(" HTTP/1.1");
        return sb.toString();
    }

    public static String toString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }
}

