/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.mixedmode;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.ConnectionDefinition;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.security.auth.Subject;

@ConnectionDefinition(connectionFactory=TSConnectionFactory.class, connectionFactoryImpl=TSEISDataSource.class, connection=TSConnection.class, connectionImpl=TSEISConnection.class)
public class PMDManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
Referenceable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private int count;
    private String password;
    private String user;
    private String userName;
    @ConfigProperty(defaultValue="PMDManagedConnectionFactory", description={"String value"}, ignore=false, supportsDynamicUpdates=false, confidential=false)
    String factoryName;
    @ConfigProperty(description={"String value"}, ignore=false)
    String noDefaultValue = "NO_DEFAULT_VAL";

    public void setFactoryName(String name) {
        String str = "PMDManagedConnectionFactory factoryname=" + name;
        ConnectorStatus.getConnectorStatus().logState(str);
        this.debug(str);
        this.factoryName = name;
        str = "PMDManagedConnectionFactory noDefaultValue=" + this.noDefaultValue;
        ConnectorStatus.getConnectorStatus().logState(str);
        this.debug(str);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setNoDefaultValue(String val) {
        this.noDefaultValue = val;
    }

    public String getNoDefaultValue() {
        return this.noDefaultValue;
    }

    public String getUser() {
        this.debug("PMDManagedConnectionFactory.getUser() returning:  " + this.user);
        return this.user;
    }

    public void setUser(String val) {
        this.debug("PMDManagedConnectionFactory.setUser() with val = " + val);
        this.user = val;
    }

    public String getUserName() {
        this.debug("PMDManagedConnectionFactory.getUserName() returning:  " + this.userName);
        return this.userName;
    }

    public void setUserName(String val) {
        this.debug("PMDManagedConnectionFactory.setUserName() with val = " + val);
        this.userName = val;
    }

    public String getPassword() {
        this.debug("PMDManagedConnectionFactory.getPassword() returning:  " + this.password);
        return this.password;
    }

    public void setPassword(String val) {
        this.debug("PMDManagedConnectionFactory.setPassword() with val = " + val);
        this.password = val;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("PMDManagedConnectionFactory.createConnectionFactory", "cxManager", "TSEISDataSource");
        return new TSEISDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("PMDManagedConnectionFactory.createConnectionFactory", "", "TSEISDataSource");
        return new TSEISDataSource(this, null);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = new String("PMDManagedConnectionFactory setResourceAdapter " + this.count);
        this.debug(newStr1);
        this.resourceAdapter = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        this.debug("PMDManagedConnectionFactory.getResource");
        return this.resourceAdapter;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            ConnectorStatus.getConnectorStatus().logAPI("PMDManagedConnectionFactory.createManagedConnection", "subject|info", "TSManagedConnection");
            TSConnection con = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                this.debug("PMDManagedConnectionFactory.createManagedConnection():  pc == null");
                this.debug("TSConnectionImpl.getConnection()");
                con = new TSConnectionImpl().getConnection();
            } else {
                this.debug("PMDManagedConnectionFactory.createManagedConnection():  pc != null");
                this.setUser(pc.getUserName());
                this.setUserName(pc.getUserName());
                this.setPassword(new String(pc.getPassword()));
                this.debug("TSConnectionImpl.getConnection(u,p)");
                con = new TSConnectionImpl().getConnection(pc.getUserName(), pc.getPassword());
            }
            TSManagedConnection mcon = new TSManagedConnection(this, pc, null, con, false, true);
            return mcon;
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("PMDManagedConnectionFactory.matchManagedConnection", "connectionSet|subject|info", "TSEISDataSource");
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || mcf == null || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PMDManagedConnectionFactory)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PMDManagedConnectionFactory that = (PMDManagedConnectionFactory)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals(that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (!Util.isEqual(this.password, that.getPassword())) {
            return false;
        }
        if (!Util.isEqual(this.user, that.getUser())) {
            return false;
        }
        if (!Util.isEqual(this.userName, that.getUserName())) {
            return false;
        }
        if (!Util.isEqual(this.factoryName, that.getFactoryName())) {
            return false;
        }
        return Util.isEqual(this.noDefaultValue, that.getNoDefaultValue());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public void debug(String out) {
        Debug.trace("PMDManagedConnectionFactory:  " + out);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }
}

