/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.container.completioncallback;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JdkLoggingFilter;
import com.sun.ts.tests.jaxrs.common.provider.StringBean;
import com.sun.ts.tests.jaxrs.common.provider.StringBeanEntityProvider;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.AsyncResponseBlockingQueue;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.Resource;
import com.sun.ts.tests.jaxrs.platform.container.completioncallback.CallbackResource;
import com.sun.ts.tests.jaxrs.platform.container.completioncallback.ExceptionThrowingStringBean;
import com.sun.ts.tests.jaxrs.platform.container.completioncallback.SecondSettingCompletionCallback;
import com.sun.ts.tests.jaxrs.platform.container.completioncallback.SettingCompletionCallback;
import com.sun.ts.tests.jaxrs.platform.container.completioncallback.TSAppConfig;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -234268814434213796L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_container_completioncallback_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/container/completioncallback/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_container_completioncallback_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, CallbackResource.class, ExceptionThrowingStringBean.class, SecondSettingCompletionCallback.class, SettingCompletionCallback.class, Resource.class, AsyncResponseBlockingQueue.class, StringBean.class, StringBeanEntityProvider.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void argumentIsNullTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        String expectedResponse = "Expected response";
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("register?stage=0");
        Future<Response> resume = this.invokeRequest("resume?stage=1", expectedResponse);
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertString(register, "A method returned false");
        JAXRSClientIT.assertString(suspend, expectedResponse);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, "NULL");
    }

    @Test
    public void argumentContainsExceptionTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("register?stage=0");
        JAXRSClientIT.logMsg("Register response test");
        JAXRSClientIT.assertString(register, "A method returned false");
        Future<Response> exception = this.invokeRequest("exception?stage=1");
        JAXRSClientIT.logMsg("Exception response test");
        Response response = JAXRSClientIT.getResponse(exception);
        JAXRSClientIT.logMsg("Gotten response status", response.getStatus());
        JAXRSClientIT.logMsg("Suspend response test");
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.INTERNAL_SERVER_ERROR);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, RuntimeException.class.getName());
    }

    @Test
    public void argumentContainsExceptionWhenSendingIoExceptionTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("register?stage=0");
        JAXRSClientIT.logMsg("Register response test");
        JAXRSClientIT.assertString(register, "A method returned false");
        Future<Response> exception = this.invokeRequest("resumechecked?stage=1");
        JAXRSClientIT.logMsg("Exception response test");
        Response response = JAXRSClientIT.getResponse(exception);
        JAXRSClientIT.logMsg("Gotten response status", response.getStatus());
        JAXRSClientIT.logMsg("Suspend response test");
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.INTERNAL_SERVER_ERROR);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, IOException.class.getName());
    }

    @Test
    public void argumentIsNullWhenRegistredClassTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        String expectedResponse = "Expected response";
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerclass?stage=0");
        Future<Response> resume = this.invokeRequest("resume?stage=1", expectedResponse);
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertString(register, "A method returned false");
        JAXRSClientIT.assertString(suspend, expectedResponse);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, "NULL");
    }

    @Test
    public void registerClassThrowsNpeTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerclassthrows?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    @Test
    public void argumentContainsExceptionInTwoCallbackClassesTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerclasses?stage=0");
        JAXRSClientIT.logMsg("Register response test");
        JAXRSClientIT.assertString(register, "A method returned false");
        Future<Response> exception = this.invokeRequest("exception?stage=1");
        JAXRSClientIT.logMsg("Exception response test");
        Response response = JAXRSClientIT.getResponse(exception);
        JAXRSClientIT.logMsg("Gotten response status", response.getStatus());
        JAXRSClientIT.logMsg("Suspend response test");
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.INTERNAL_SERVER_ERROR);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, RuntimeException.class.getName());
        error = this.invokeRequest("seconderror");
        JAXRSClientIT.assertString(error, RuntimeException.class.getName());
    }

    @Test
    public void registerClassesThrowsNpeFirstArgNullTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerclassesthrows1?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    @Test
    public void registerClassesThrowsNpeSecondArgNullTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerclassesthrows2?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    @Test
    public void registerObjectThrowsNpeTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerthrows?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    @Test
    public void argumentContainsExceptionInTwoCallbackInstancesTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerobjects?stage=0");
        JAXRSClientIT.logMsg("Register response test");
        JAXRSClientIT.assertString(register, "A method returned false");
        Future<Response> exception = this.invokeRequest("exception?stage=1");
        JAXRSClientIT.logMsg("Exception response test");
        Response response = JAXRSClientIT.getResponse(exception);
        JAXRSClientIT.logMsg("Gotten response status", response.getStatus());
        JAXRSClientIT.logMsg("Suspend response test");
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.INTERNAL_SERVER_ERROR);
        Future<Response> error = this.invokeRequest("error");
        JAXRSClientIT.assertString(error, RuntimeException.class.getName());
        error = this.invokeRequest("seconderror");
        JAXRSClientIT.assertString(error, RuntimeException.class.getName());
    }

    @Test
    public void registerInstancesThrowsNpeFirstArgNullTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerobjectsthrows1?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    @Test
    public void registerInstancesThrowsNpeSecondArgNullTest() throws Exception {
        this.invokeClear();
        this.invokeReset();
        this.invokeRequest("suspend");
        Future<Response> register = this.invokeRequest("registerobjectsthrows2?stage=0");
        JAXRSClientIT.assertString(register, "A method return true");
        JAXRSClientIT.logMsg("Register threw NullPointerException as expected");
    }

    private void invokeClear() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "clear"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    private void invokeReset() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "reset"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    private Future<Response> invokeRequest(String resource) {
        AsyncInvoker async = this.createAsyncInvoker(resource);
        Future future = async.get();
        return future;
    }

    private <T> Future<Response> invokeRequest(String resource, T entity) {
        AsyncInvoker async = this.createAsyncInvoker(resource);
        Future future = async.post(Entity.entity(entity, (MediaType)MediaType.TEXT_PLAIN_TYPE));
        return future;
    }

    private WebTarget createWebTarget(String resource) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(true));
        WebTarget target = client.target(this.getAbsoluteUrl() + "/" + resource);
        return target;
    }

    private AsyncInvoker createAsyncInvoker(String resource) {
        WebTarget target = this.createWebTarget(resource);
        AsyncInvoker async = target.request().async();
        return async;
    }

    private static Response getResponse(Future<Response> future) throws Exception {
        Response response = null;
        try {
            response = future.get();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return response;
    }

    private static void assertStatus(Response response, Response.Status status) throws Exception {
        JAXRSClientIT.assertEqualsInt(response.getStatus(), status.getStatusCode(), "Unexpected status code received", response.getStatus(), "expected was", status);
        JAXRSClientIT.logMsg("Found expected status", status);
    }

    private static void assertString(Future<Response> future, String check) throws Exception {
        Response response = JAXRSClientIT.getResponse(future);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
        String content = (String)response.readEntity(String.class);
        JAXRSClientIT.assertEquals(check, content, "Unexpected response content", content, "expecting", check);
        JAXRSClientIT.logMsg("Found expected string", check);
    }

    private static void assertException(Future<Response> future, Class<? extends Throwable> e) throws Exception {
        String clazz = e.getName();
        Response response = JAXRSClientIT.getResponse(future);
        JAXRSClientIT.assertStatus(response, Response.Status.INTERNAL_SERVER_ERROR);
        JAXRSClientIT.assertContains((String)response.readEntity(String.class), clazz, new Object[]{clazz, "not thrown"});
        JAXRSClientIT.logMsg(clazz, "has been thrown as expected");
    }
}

