/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.tx.common.web;

import com.sun.ts.tests.ejb30.tx.common.web.LocalIF;
import com.sun.ts.tests.ejb30.tx.common.web.RemoteIF;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.PrintWriter;

public class TxServlet
extends HttpServlet {
    @Resource(name="ut")
    private UserTransaction ut;
    @EJB(name="localBean")
    private LocalIF localBean;
    @EJB(name="remoteBean")
    private RemoteIF remoteBean;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String testName = req.getParameter("testname");
        if (testName == null) {
            throw new ServletException("request parameter testname is not set.");
        }
        if ("interServletTxPropagation".equals(testName)) {
            this.interServletTxPropagation(req, resp);
            return;
        }
        if ("interServletTxPropagation2".equals(testName)) {
            this.interServletTxPropagation2(req, resp);
            return;
        }
        if ("servletRemoteCmtRequiresNew".equals(testName)) {
            this.remoteBean.requiresNew();
            return;
        }
        if ("servletLocalCmtRequiresNew".equals(testName)) {
            this.localBean.requiresNew();
            return;
        }
        if ("servletRemoteCmtNever".equals(testName)) {
            this.servletRemoteCmtNever(req, resp);
            return;
        }
        if ("servletLocalCmtNever".equals(testName)) {
            this.servletLocalCmtNever(req, resp);
            return;
        }
        try {
            this.ut.begin();
            if ("servletRemoteCmt".equals(testName)) {
                this.remoteBean.required();
            } else if ("servletLocalCmt".equals(testName)) {
                this.localBean.required();
            } else if ("servletRemoteCmtMandatory".equals(testName)) {
                this.remoteBean.mandatory();
            } else if ("servletLocalCmtMandatory".equals(testName)) {
                this.localBean.mandatory();
            }
        }
        catch (NotSupportedException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SystemException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void servletRemoteCmtNever(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        try {
            this.remoteBean.never();
            pw.println("Test FAILED, didn't get expected EJBException");
        }
        catch (EJBException e) {
            pw.println("Test PASSED, got expected exception");
        }
    }

    private void servletLocalCmtNever(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        try {
            this.localBean.never();
            pw.println("Test FAILED, didn't get expected EJBException");
        }
        catch (EJBException e) {
            pw.println("Test PASSED, got expected exception");
        }
    }

    private void interServletTxPropagation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        try {
            int status = this.ut.getStatus();
            if (status == 0) {
                pw.println("Test PASSED, tx is active in the called servlet");
            } else {
                pw.println("Test FAILED, tx is not active in the called servlet. tx status is " + status);
            }
        }
        catch (SystemException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void interServletTxPropagation2(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.interServletTxPropagation(req, resp);
        try {
            this.ut.rollback();
        }
        catch (SystemException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

