/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import org.jboss.cdi.tck.tests.context.request.SimpleRequestBean;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebListener
public class TestServletRequestListener
implements ServletRequestListener {
    private static final SimpleLogger logger = new SimpleLogger(TestServletRequestListener.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleRequestBean simpleBean;

    public void requestDestroyed(ServletRequestEvent sre) {
        logger.log("Request destroyed...", new Object[0]);
        this.checkRequestContextActive();
        String mode = sre.getServletRequest().getParameter("mode");
        if ("collect".equals(mode)) {
            ActionSequence.addAction((String)TestServletRequestListener.class.getName());
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        logger.log("Request initialized...", new Object[0]);
        this.checkRequestContextActive();
    }

    private void checkRequestContextActive() throws IllegalStateException {
        if (this.beanManager == null || !this.beanManager.getContext(RequestScoped.class).isActive() || this.simpleBean == null) {
            throw new IllegalStateException("Request context is not active");
        }
        this.simpleBean.getId();
    }
}

