/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeyclass;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeyclass.Course;
import ee.jakarta.tck.persistence.core.annotations.mapkeyclass.Semester;
import ee.jakarta.tck.persistence.core.annotations.mapkeyclass.Student;
import jakarta.persistence.EntityManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    private Map<Course, Semester> student2EnrollmentMap;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void mapKeyClass() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.createEntities();
            this.getEntityManager().flush();
            this.clearCache();
            this.clearCache();
            Student student = (Student)this.getEntityManager().find(Student.class, (Object)2);
            Set<Course> courses = student.getCourses();
            if (courses != null) {
                if (courses.containsAll(this.student2EnrollmentMap.keySet()) && this.student2EnrollmentMap.keySet().containsAll(courses) && courses.size() == this.student2EnrollmentMap.keySet().size()) {
                    pass = true;
                }
            } else {
                this.logErr("getCourses() returned null value");
            }
            this.clearCache();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred:", e);
        }
        if (!pass) {
            throw new Exception("mapKeyClass Failed");
        }
    }

    public void createEntities() {
        Student student1 = new Student(1, "Neo");
        Student student2 = new Student(2, "Vivek");
        Semester semester1 = new Semester(1);
        Semester semester2 = new Semester(2);
        Semester semester3 = new Semester(3);
        Course appliedMath = new Course(101, "AppliedMathematics");
        Course physics = new Course(102, "Physics");
        Course operationResearch = new Course(103, "OperationResearch");
        Course statistics = new Course(201, "Statistics");
        Hashtable<Course, Semester> student1EnrollmentMap = new Hashtable<Course, Semester>();
        student1EnrollmentMap.put(appliedMath, semester1);
        student1EnrollmentMap.put(physics, semester1);
        student1EnrollmentMap.put(statistics, semester2);
        student1.setEnrollment(student1EnrollmentMap);
        this.student2EnrollmentMap = new Hashtable<Course, Semester>();
        this.student2EnrollmentMap.put(appliedMath, semester1);
        this.student2EnrollmentMap.put(physics, semester1);
        this.student2EnrollmentMap.put(operationResearch, semester3);
        this.student2EnrollmentMap.put(statistics, semester3);
        student2.setEnrollment(this.student2EnrollmentMap);
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist((Object)student1);
        entityManager.persist((Object)student2);
        this.logTrace("persisted 2 students");
        entityManager.persist((Object)semester1);
        entityManager.persist((Object)semester2);
        entityManager.persist((Object)semester3);
        this.logTrace("persisted 4 semesters");
        entityManager.persist((Object)appliedMath);
        entityManager.persist((Object)physics);
        entityManager.persist((Object)operationResearch);
        entityManager.persist((Object)statistics);
        this.logTrace("persisted 4 Courses");
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from ENROLLMENTS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from SEMESTER").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in RemoveSchemaData:", re);
            }
        }
    }
}

