/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.apitests;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.apitests.Bar;
import ee.jakarta.tck.persistence.core.entitytest.apitests.Coffee;
import ee.jakarta.tck.persistence.core.entitytest.apitests.Foo;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static Coffee[] cRef = new Coffee[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAPITest1() throws Exception {
        Foo notAnEntity = new Foo();
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)notAnEntity);
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException e) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + e);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest1 failed");
        }
    }

    public void entityAPITest2() throws Exception {
        boolean pass = false;
        try {
            Coffee doesNotExist = (Coffee)this.getEntityManager().find(Coffee.class, (Object)55);
            if (null == doesNotExist) {
                this.logTrace("find returned null as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest2 failed");
        }
    }

    public void entityAPITest3() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().find(Foo.class, (Object)1);
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAPITest4() throws Exception {
        long longId = 55L;
        boolean pass = false;
        try {
            Coffee coffee = (Coffee)this.getEntityManager().find(Coffee.class, (Object)longId);
            if (coffee == null) {
                this.logTrace("coffee is null");
            }
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest4 failed");
        }
    }

    public void getReferenceExceptionsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        this.logMsg("Testing getReference invalid entity");
        try {
            this.getEntityManager().getReference(Foo.class, (Object)1);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing getReference with invalid PK");
        try {
            this.getEntityManager().getReference(Coffee.class, (Object)"1");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing getReference with null PK");
        try {
            this.getEntityManager().getReference(Coffee.class, null);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass3 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getReferenceExceptionsTest failed");
        }
    }

    public void getReferenceTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Coffee thisCoffee = (Coffee)this.getEntityManager().getReference(Coffee.class, (Object)1);
            if (thisCoffee != null) {
                pass = true;
                this.logTrace("Got Reference");
            } else {
                this.logErr("getReference(Coffee.class, 1) returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("getReferenceTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAPITest8() throws Exception {
        Foo notAnEntity = new Foo();
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)notAnEntity);
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAPITest10() throws Exception {
        Foo notAnEntity = new Foo();
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains((Object)notAnEntity);
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest10 failed");
        }
    }

    public void entityAPITest12() throws Exception {
        List result = null;
        boolean pass = false;
        boolean passCounter = false;
        int i = 0;
        Integer[] expected = new Integer[cRef.length];
        for (Coffee c : cRef) {
            expected[i++] = c.getId();
        }
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("findAllCoffees").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == cRef.length) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("entityAPITest12 failed");
        }
    }

    public void entityAPITest13() throws Exception {
        List result = null;
        boolean pass = false;
        boolean passCounter = false;
        int i = 0;
        Integer[] expected = new Integer[cRef.length];
        for (Coffee c : cRef) {
            expected[i++] = c.getId();
        }
        try {
            this.getEntityTransaction().begin();
            this.logTrace("invoke query method, findallSQLCoffees");
            result = this.getEntityManager().createNamedQuery("findAllSQLCoffees").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == cRef.length) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("entityAPITest13 failed");
        }
    }

    public void entityAPITest14() throws Exception {
        List result = null;
        boolean pass = false;
        boolean passCounter = false;
        int i = 0;
        Integer[] expected = new Integer[cRef.length];
        for (Coffee c : cRef) {
            expected[i++] = c.getId();
        }
        try {
            this.getEntityTransaction().begin();
            this.logTrace("invoke query method, findAllNewCoffees");
            result = this.getEntityManager().createNamedQuery("findAllNewCoffees").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == cRef.length) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("entityAPITest14 failed");
        }
    }

    public void entityAPITest15() throws Exception {
        List result = null;
        boolean pass = false;
        boolean passCounter = false;
        int i = 0;
        Integer[] expected = new Integer[cRef.length];
        for (Coffee c : cRef) {
            expected[i++] = c.getId();
        }
        try {
            this.getEntityTransaction().begin();
            this.logTrace("try same constructor expression query using createQuery");
            result = this.getEntityManager().createQuery("Select NEW ee.jakarta.tck.persistence.core.entitytest.apitests.Coffee(c.id, c.brandName, c.price) from Coffee c where c.price <> 0").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == cRef.length) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("entityAPITest15 failed");
        }
    }

    public void entityAPITest16() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{cRef[4].getId()};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute query in entityAPITest16");
            result = this.getEntityManager().createQuery("Select NEW ee.jakarta.tck.persistence.core.entitytest.apitests.Bar(c.id, c.brandName, c.price) from Coffee c where c.brandName = 'mocha'").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else {
                this.logTrace("Received expected id");
                if (((Bar)result.get(0)).getBrandName().equals(cRef[4].getBrandName()) && ((Bar)result.get(0)).getPrice().equals(cRef[4].getPrice())) {
                    pass = true;
                } else {
                    this.logErr("Did not get expected results. Expected " + expected[0].toString() + ", got: " + ((Bar)result.get(0)).toString());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("entityAPITest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAPITest17() throws Exception {
        Foo notAnEntity = new Foo();
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)notAnEntity);
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException e) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + e);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("entityAPITest17 failed");
        }
    }

    public void entityAPITest18() throws Exception {
        List result = null;
        boolean pass = false;
        int i = 0;
        Integer[] expected = new Integer[cRef.length];
        for (Coffee c : cRef) {
            expected[i++] = c.getId();
        }
        try {
            this.getEntityTransaction().begin();
            this.logTrace("invoke query method, findAllSQLCoffees2");
            result = this.getEntityManager().createNamedQuery("findAllSQLCoffees2").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("entityAPITest18 failed");
        }
    }

    public void xmlOverridesNamedNativeQueryTest() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{cRef[2].getId()};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("xmlOverridesNamedNativeQuery").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("xmlOverridesNamedNativeQueryTest failed");
        }
    }

    public void xmlNamedNativeQueryTest() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{cRef[2].getId()};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("xmlNamedNativeQuery").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("xmlNamedNativeQueryTest failed");
        }
    }

    public void xmlOverridesNamedQueryTest() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{cRef[2].getId()};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("xmlOverridesNamedQuery").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("xmlOverridesNamedQueryTest failed");
        }
    }

    public void xmlNamedQueryTest() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{cRef[2].getId()};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("xmlNamedQuery").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("xmlNamedQueryTest failed");
        }
    }

    public void namedNativeQueryInMappedSuperClass() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{3};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("findDecafSQLCoffees").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("namedNativeQueryInMappedSuperClass failed");
        }
    }

    public void namedQueryInMappedSuperClass() throws Exception {
        List result = null;
        boolean pass = false;
        Integer[] expected = new Integer[]{3};
        try {
            this.getEntityTransaction().begin();
            result = this.getEntityManager().createNamedQuery("findDecafCoffees").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else if (this.verifyEntity(result) == 1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("namedQueryInMappedSuperClass failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 Coffees");
            Client.cRef[0] = new Coffee(1, "hazelnut", 1.0f);
            Client.cRef[1] = new Coffee(2, "vanilla creme", 2.0f);
            Client.cRef[2] = new Coffee(3, "decaf", 3.0f);
            Client.cRef[3] = new Coffee(4, "breakfast blend", 4.0f);
            Client.cRef[4] = new Coffee(5, "mocha", 5.0f);
            this.logTrace("Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                this.logTrace("persisted coffee " + c);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    private int verifyEntity(List<Coffee> result) {
        this.logTrace("in verifyEntity");
        int passCounter = 0;
        for (Coffee c : result) {
            this.logTrace("Verifying:" + c);
            if (c.getBrandName().equals(cRef[c.getId() - 1].getBrandName()) && c.getPrice().equals(cRef[c.getId() - 1].getPrice())) {
                ++passCounter;
                continue;
            }
            this.logErr("Did not get expected results. Expected " + cRef[c.getId() - 1] + ", got: " + c);
        }
        return passCounter;
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

