/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.sessionTtests;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.TestsT;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.sessionTtests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient Connection connr = null;
    @Resource(name="jms/DURABLE_SUB_CONNECTION_FACTORY")
    private static ConnectionFactory cf;
    @Resource(name="jms/MY_TOPIC")
    private static Topic testDestination;
    private String name = "ctssub";
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/SessionTestsT")
    private static TestsT beanRef;

    public static void main(String[] args) {
        Client theTestsT = new Client();
        Status s = theTestsT.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            if (beanRef == null) {
                throw new Exception("@EJB injection failed");
            }
            if (cf == null || testDestination == null) {
                throw new Exception("@Resource injection failed");
            }
            this.props = p;
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
    }

    public void simpleSendReceiveT() throws Exception {
        String testMessage = "Just a test from simpleSendReceiveT";
        String messageReceived = null;
        try {
            this.connr = cf.createConnection(this.user, this.password);
            if (this.connr.getClientID() == null) {
                this.connr.setClientID("cts");
            }
            Session sessr = this.connr.createSession(true, 1);
            TopicSubscriber recr = sessr.createDurableSubscriber(testDestination, this.name);
            try {
                recr.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception closing topic subscriber: ", (Throwable)e);
            }
            try {
                this.connr.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception closing connection: ", (Throwable)e);
            }
            beanRef.sendTextMessage_CT(testName, testMessage);
            messageReceived = beanRef.receiveTextMessage_CT();
            if (messageReceived == null) {
                throw new Exception("Null message received!");
            }
            if (!messageReceived.equals(testMessage)) {
                throw new Exception("EJB didn't get the right message");
            }
            TestUtil.logMsg((String)"Correct Message received");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("simpleSendReceiveT");
        }
        finally {
            try {
                this.connr = cf.createConnection(this.user, this.password);
                Session sessr = this.connr.createSession(true, 1);
                try {
                    sessr.unsubscribe(this.name);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception unsubscribing: ", (Throwable)e);
                }
                try {
                    this.connr.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception closing connection: ", (Throwable)e);
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception creating Connection: ", (Throwable)e);
            }
            try {
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

