/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.Set;

public class Client7
extends Util {
    public static void main(String[] args) {
        Client7 theTests = new Client7();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void getCorrelatedJoinsTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Order.class);
            Set cJoins = sq.getCorrelatedJoins();
            if (cJoins != null) {
                if (cJoins.size() == 0) {
                    this.logErr("Received expected 0 correlated joins from subquery.getCorrelatedJoins() when none exist");
                    CollectionJoin sqo = sq.correlate(customer.join(Customer_.orders));
                    sq.select((Expression)sqo);
                    cJoins = sq.getCorrelatedJoins();
                    if (cJoins != null) {
                        if (cJoins.size() == 1) {
                            this.logTrace("Received expected 1 correlated join from subquery.getCorrelatedJoins()");
                            pass = true;
                        } else {
                            this.logErr("Received " + cJoins.size() + " correlated joins from subquery.getCorrelatedJoins() when 1 exist");
                        }
                    } else {
                        this.logErr("Received null from subquery.getCorrelatedJoins() when 1 correlated join exists");
                    }
                } else {
                    this.logErr("Received " + cJoins.size() + " unexpected correlated joins from subquery.getCorrelatedJoins() when non exist");
                }
            } else {
                this.logErr("Received null from subquery.getCorrelatedJoins() instead of empty set when non exist");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" getCorrelatedJoinsTest failed");
        }
    }
}

