/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.fmt.i18n.requestencoding;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_fmt_reqenc_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_fmt_reqenc_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_fmt_reqenc_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveContentTypeEncodingTest.jsp")), "positiveContentTypeEncodingTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveDefaultEncodingTest.jsp")), "positiveDefaultEncodingTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveReqEncodingValueTest.jsp")), "positiveReqEncodingValueTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveScopedAttrEncodingTest.jsp")), "positiveScopedAttrEncodingTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveReqEncodingValueTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveReqEncodingValueTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveReqEncodingValueTest");
        this.invoke();
    }

    @Test
    public void positiveContentTypeEncodingTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveContentTypeEncodingTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveContentTypeEncodingTest");
        TEST_PROPS.setProperty("request", "positiveContentTypeEncodingTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Content-Type: text/plain; charset=UTF-8");
        this.invoke();
    }

    @Test
    public void positiveScopedAttrEncodingTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveScopedAttrEncodingTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveScopedAttrEncodingTest");
        this.invoke();
    }

    @Test
    public void positiveDefaultEncodingTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveDefaultEncodingTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveDefaultEncodingTest");
        this.invoke();
    }
}

