/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.manyXone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXone.A;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachMX1Test1() throws Exception {
        this.logTrace("Begin detachMX1Test1");
        boolean pass = false;
        A aRef = new A("3", "a3", 3);
        try {
            this.logTrace("Persist Instance");
            this.createA(aRef);
            this.logTrace("Call EntityManager.clear()");
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("Call getEntityManager.contains to determine if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                this.logTrace("entity is not detached, unexpected cannot proceed with test.");
            } else {
                try {
                    this.logTrace("Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                    this.logMsg("Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logMsg("received expected IllegalArgumentException when trying to persist a detached entity");
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    this.logMsg("EntityExistsException thrown trying to persist an existing entity");
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logMsg("or, Transaction commit will fail.   Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                this.logMsg("Received exception TransactionRolledbackException or PersistenceException");
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("detachMX1Test1 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

