/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.joincolumn;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.joincolumn.DID2Dependent;
import ee.jakarta.tck.persistence.jpa22.repeatable.joincolumn.DID2DependentId;
import ee.jakarta.tck.persistence.jpa22.repeatable.joincolumn.DID2Employee;
import ee.jakarta.tck.persistence.jpa22.repeatable.joincolumn.DID2EmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void didTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID2EmployeeId eId1 = new DID2EmployeeId("Java", "Duke");
            DID2EmployeeId eId2 = new DID2EmployeeId("C", "foo");
            DID2Employee employee1 = new DID2Employee(eId1);
            DID2Employee employee2 = new DID2Employee(eId2);
            DID2DependentId dId1 = new DID2DependentId("Obama", eId1);
            DID2DependentId dId2 = new DID2DependentId("Michelle", eId1);
            DID2DependentId dId3 = new DID2DependentId("John", eId2);
            DID2Dependent dep1 = new DID2Dependent(dId1, employee1);
            DID2Dependent dep2 = new DID2Dependent(dId2, employee1);
            DID2Dependent dep3 = new DID2Dependent(dId3, employee2);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().flush();
            this.logTrace("persisted Employees and Dependents");
            DID2Dependent newDependent = (DID2Dependent)this.getEntityManager().find(DID2Dependent.class, (Object)new DID2DependentId("Obama", new DID2EmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2Dependent d where d.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    this.logTrace("Received Expected Dependent");
                } else {
                    this.logErr("Searched Dependent not found");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

