/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.sql.query;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.jstl.sql.Result;
import jakarta.servlet.jsp.jstl.sql.ResultSupport;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ResultSetQueryTag
extends BodyTagSupport
implements TryCatchFinally {
    private String var;
    private int scope;
    protected Object rawDataSource;
    protected String sql;
    protected int maxRows;
    protected boolean maxRowsSpecified;
    protected int startRow;
    private Connection conn;

    public ResultSetQueryTag() {
        this.init();
    }

    private void init() {
        this.startRow = 0;
        this.maxRows = -1;
        this.maxRowsSpecified = false;
        this.conn = null;
        this.rawDataSource = null;
        this.sql = null;
        this.var = null;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setDataSource(Object dataSource) {
        this.rawDataSource = dataSource;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.maxRowsSpecified = true;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int doStartTag() throws JspException {
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            throw new JspException(this.sql + ": " + e.getMessage(), (Throwable)e);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        String sqlStatement = null;
        if (this.sql != null) {
            sqlStatement = this.sql;
        } else if (this.bodyContent != null) {
            sqlStatement = this.bodyContent.getString();
        }
        if (sqlStatement == null || sqlStatement.trim().length() == 0) {
            throw new JspTagException("No sql statement from attribute or body content.");
        }
        if (this.startRow < 0 || this.maxRows < -1) {
            throw new JspException("startRow less than 0 or maxRow less than -1");
        }
        Result result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Throwable queryError = null;
        try {
            ps = this.conn.prepareStatement(sqlStatement);
            rs = ps.executeQuery();
            result = this.maxRowsSpecified ? ResultSupport.toResult((ResultSet)rs, (int)this.maxRows) : ResultSupport.toResult((ResultSet)rs);
            ps.close();
        }
        catch (Throwable e) {
            queryError = e;
            return (int)queryError;
        }
        finally {
            SQLException rsCloseExc = null;
            SQLException psCloseExc = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqe) {
                    rsCloseExc = sqe;
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqe) {
                    psCloseExc = sqe;
                }
            }
            if (queryError != null) {
                throw new JspException(sqlStatement + ": " + queryError.getMessage(), queryError);
            }
            if (rsCloseExc != null) {
                throw new JspException(rsCloseExc.getMessage(), (Throwable)rsCloseExc);
            }
            if (psCloseExc != null) {
                throw new JspException(psCloseExc.getMessage(), (Throwable)psCloseExc);
            }
        }
        this.pageContext.setAttribute(this.var, (Object)result, this.scope);
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.conn = null;
    }

    private Connection getConnection() throws JspException, SQLException {
        Connection conn = null;
        if (this.rawDataSource == null) {
            throw new JspException("dataSource attribute is null.");
        }
        DataSource dataSource = null;
        if (!(this.rawDataSource instanceof DataSource)) {
            throw new JspException("dataSource attribute must be of type javax.sql.DataSource.");
        }
        dataSource = (DataSource)this.rawDataSource;
        try {
            conn = dataSource.getConnection();
        }
        catch (Exception ex) {
            throw new JspException((Throwable)ex);
        }
        return conn;
    }
}

