/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient.http;

import com.sun.ts.lib.porting.TSURL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class MethodFactory {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String OPTIONS_METHOD = "OPTIONS";
    private static final TSURL TS_URL = new TSURL();

    private MethodFactory() {
    }

    public static HttpMethod getInstance(String request) {
        GetMethod req;
        String version;
        String uri;
        String method;
        StringTokenizer st = new StringTokenizer(request);
        String query = null;
        try {
            method = st.nextToken();
            uri = TS_URL.getRequest(st.nextToken());
            version = st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Request provided: " + request + " is malformed.");
        }
        int queryStart = uri.indexOf(63);
        if (queryStart != -1) {
            query = uri.substring(queryStart + 1);
            uri = uri.substring(0, queryStart);
        }
        if (method.equals(GET_METHOD)) {
            req = new GetMethod(uri);
        } else if (method.equals(POST_METHOD)) {
            req = new PostMethod(uri);
        } else if (method.equals(PUT_METHOD)) {
            req = new PutMethod(uri);
        } else if (method.equals(DELETE_METHOD)) {
            req = new DeleteMethod(uri);
        } else if (method.equals(HEAD_METHOD)) {
            req = new HeadMethod(uri);
        } else if (method.equals(OPTIONS_METHOD)) {
            req = new OptionsMethod(uri);
        } else {
            throw new IllegalArgumentException("Invalid method: " + method);
        }
        MethodFactory.setHttpVersion(version, (HttpMethodBase)req);
        if (query != null) {
            req.setQueryString(query);
        }
        return req;
    }

    private static void setHttpVersion(String version, HttpMethodBase method) {
        String oneOne = "HTTP/1.1";
        method.getParams().setVersion(version.equals("HTTP/1.1") ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0);
    }
}

