/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.SerializersCustomizationCDITest;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.Animal;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.AnimalShelterWithInjectedSerializer;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.Cat;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.Dog;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalBuilder;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalDeserializer;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalDeserializerInjected;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalListDeserializerInjected;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalListSerializer;
import com.sun.ts.tests.jsonb.cdi.customizedmapping.serializers.model.serializer.AnimalSerializer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@Tags(value={@Tag(value="tck-javatest"), @Tag(value="jsonb"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class SerializersCustomizationCDIServletTest
extends SerializersCustomizationCDITest {
    private static final long serialVersionUID = 10L;
    static final String VEHICLE_ARCHIVE = "jsonb_cdi_customizedmapping_serializers_servlet_vehicle";
    private final Jsonb jsonb = JsonbBuilder.create();
    private static final System.Logger logger = System.getLogger(SerializersCustomizationCDIServletTest.class.getName());
    private static String packagePath = SerializersCustomizationCDIServletTest.class.getPackageName().replace(".", "/");

    public static void main(String[] args) {
        SerializersCustomizationCDIServletTest t = new SerializersCustomizationCDIServletTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="jsonb_cdi_customizedmapping_serializers_servlet_vehicle", testable=true)
    public static WebArchive createServletDeployment() throws Exception {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsonb_cdi_customizedmapping_serializers_servlet_vehicle_web.war");
        war.addClasses(new Class[]{SerializersCustomizationCDIServletTest.class, ServletVehicle.class, VehicleRunnerFactory.class, VehicleRunnable.class, VehicleClient.class, EETest.class, EETest.SetupException.class, EETest.Fault.class, ServiceEETest.class, AnimalBuilder.class, AnimalBuilder.TYPE.class, AnimalDeserializer.class, AnimalDeserializerInjected.class, AnimalListDeserializerInjected.class, AnimalListSerializer.class, AnimalSerializer.class, Animal.class, AnimalShelterWithInjectedSerializer.class, Cat.class, Dog.class, SerializersCustomizationCDITest.class});
        war.setWebXML(SerializersCustomizationCDIServletTest.class.getClassLoader().getResource(packagePath + "/servlet_vehicle_web.xml"));
        URL warResURL = SerializersCustomizationCDIServletTest.class.getClassLoader().getResource(packagePath + "/beans.xml");
        if (warResURL != null) {
            war.addAsWebResource(warResURL, "/WEB-INF/beans.xml");
        }
        return war;
    }

    @Override
    @Test
    @TargetVehicle(value="servlet")
    public void testCDISupport() throws Exception {
        AnimalShelterWithInjectedSerializer animalShelter = new AnimalShelterWithInjectedSerializer();
        animalShelter.addAnimal(new Cat(5, "Garfield", 10.5f, true, true));
        animalShelter.addAnimal(new Dog(3, "Milo", 5.5f, false, true));
        animalShelter.addAnimal(new Animal(6, "Tweety", 0.5f, false));
        String jsonString = this.jsonb.toJson((Object)animalShelter);
        if (!jsonString.matches("\\{\\s*\"animals\"\\s*:\\s*\\[\\s*\\{\\s*\"type\"\\s*:\\s*\"cat\"\\s*,\\s*\"cuddly\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*5\\s*,\\s*\"furry\"\\s*:\\s*true\\s*,\\s*\"name\"\\s*:\\s*\"Garfield\"\\s*,\\s*\"weight\"\\s*:\\s*10.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"dog\"\\s*,\\s*\"barking\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*3\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Milo\"\\s*,\\s*\"weight\"\\s*:\\s*5.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"animal\"\\s*,\\s*\"age\"\\s*:\\s*6\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Tweety\"\\s*,\\s*\"weight\"\\s*:\\s*0.5\\s*}\\s*]\\s*}")) {
            throw new Exception("Failed to correctly marshall complex type hierarchy using a serializer configured using JsonbTypeSerializer annotation and a deserializer with a CDI managed field configured using JsonbTypeDeserializer annotation.");
        }
        AnimalShelterWithInjectedSerializer unmarshalledObject = (AnimalShelterWithInjectedSerializer)this.jsonb.fromJson("{ \"animals\" : [ { \"type\" : \"cat\", \"cuddly\" : true, \"age\" : 5, \"furry\" : true, \"name\" : \"Garfield\" , \"weight\" : 10.5}, { \"type\" : \"dog\", \"barking\" : true, \"age\" : 3, \"furry\" : false, \"name\" : \"Milo\", \"weight\" : 5.5}, { \"type\" : \"animal\", \"age\" : 6, \"furry\" : false, \"name\" : \"Tweety\", \"weight\" : 0.5} ] }", AnimalShelterWithInjectedSerializer.class);
        if (!animalShelter.equals(unmarshalledObject)) {
            throw new Exception("Failed to correctly unmarshall complex type hierarchy using a serializer configured using JsonbTypeSerializer annotation and a deserializer with a CDI managed field configured using JsonbTypeDeserializer annotation.");
        }
    }
}

