/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeytemporal;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department2;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department4;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.EmbeddedEmployee;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee2;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee4;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 20L;
    final Date d1 = this.getUtilDate("2000-02-14");
    final Date d2 = this.getUtilDate("2001-06-27");
    final Date d3 = this.getUtilDate("2002-07-07");
    final Date d4 = this.getUtilDate("2003-03-03");
    final Date d5 = this.getSQLDate();
    final Date d6 = this.getUtilDate("2000-10-14");
    final Date d7 = this.getUtilDate("2001-11-27");
    private static Employee[] empRef = new Employee[5];
    private static Employee2[] empRef2 = new Employee2[5];
    private static Employee4[] empRef3 = new Employee4[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void mapKeyTemporalTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d1);
        expected.add(this.d2);
        expected.add(this.d3);
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            this.logTrace("Name:" + emp.getLastName());
            Department dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<Date, Employee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Date, Employee> entry : emps.entrySet()) {
                    this.logTrace("map:" + entry.getKey() + ", " + entry.getValue().getId() + " " + entry.getValue().getLastName());
                }
            }
            Set<Date> keys = emps.keySet();
            for (Date key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Date key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Date key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[1]);
            hashSet.add(empRef[2]);
            Collection<Employee> employees = emps.values();
            for (Employee e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyTemporalTest failed");
        }
    }

    public void mapKeyEnumeratedWithMayKeyClassAnnotationTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d4);
        expected.add(this.d5);
        try {
            this.getEntityTransaction().begin();
            Employee2 emp = (Employee2)this.getEntityManager().find(Employee2.class, (Object)2);
            this.logTrace("Name:" + emp.getLastName());
            Department2 dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    this.logTrace("map:" + entry.getKey() + ", " + ((Employee2)entry.getValue()).getId() + " " + ((Employee2)entry.getValue()).getLastName());
                }
            }
            Set keys = emps.keySet();
            for (Date key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Date key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Date key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee2> hashSet = new HashSet<Employee2>();
            hashSet.add(empRef2[0]);
            hashSet.add(empRef2[1]);
            Collection employees = emps.values();
            for (Employee2 e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee2 e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee2 e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyEnumeratedWithMayKeyClassAnnotationTest failed");
        }
    }

    public void elementCollectionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d6);
        expected.add(this.d7);
        try {
            this.getEntityTransaction().begin();
            Employee4 emp = (Employee4)this.getEntityManager().find(Employee4.class, (Object)6);
            this.logTrace("Name:" + emp.getLastName());
            Department4 dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<Date, EmbeddedEmployee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Date, EmbeddedEmployee> entry : emps.entrySet()) {
                    this.logTrace("set:" + entry.getKey() + ", " + entry.getValue().employeeId + " " + entry.getValue().employeeName);
                }
            }
            Set<Date> keys = emps.keySet();
            for (Date key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Date key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Date key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee4> hashSet = new HashSet<Employee4>();
            hashSet.add(empRef3[0]);
            hashSet.add(empRef3[1]);
            Collection employees = emps.values().stream().flatMap(a -> Stream.of(new Employee4(a.employeeId, a.employeeName))).collect(Collectors.toList());
            for (Employee4 e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee4 e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee4 e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("elementCollectionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create 2 - Departments");
            Department[] deptRef = new Department[]{new Department(1, "Marketing"), new Department(2, "Administration")};
            this.logTrace("Persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department " + dept.getName());
            }
            this.logTrace("Create 2 - Department2");
            Department2[] deptRef2 = new Department2[]{new Department2(3, "Development"), new Department2(4, "Release")};
            this.logTrace("Persist Department2 ");
            for (Department2 dept : deptRef2) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department2 " + dept.getName());
            }
            this.logTrace("Create 2 - Department3");
            Department4[] deptRef3 = new Department4[]{new Department4(5, "Shipping"), new Department4(6, "Receiving")};
            this.logTrace("Persist Department2s ");
            for (Department4 dept : deptRef3) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department3 " + dept.getName());
            }
            this.logTrace("Create 5 - Employee");
            Client.empRef[0] = new Employee(1, "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(3, "McGowan");
            empRef[1].setDepartment(deptRef[0]);
            Client.empRef[2] = new Employee(5, "DMilla");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef2[0] = new Employee2(2, "Smith");
            empRef2[0].setDepartment(deptRef2[0]);
            Client.empRef2[1] = new Employee2(4, "Bissett");
            empRef2[1].setDepartment(deptRef2[0]);
            Client.empRef3[0] = new Employee4(6, "Donahue");
            empRef3[0].setDepartment(deptRef3[0]);
            Client.empRef3[1] = new Employee4(7, "Sanborn");
            empRef3[1].setDepartment(deptRef3[0]);
            HashMap<Date, Employee> link = new HashMap<Date, Employee>();
            link.put(this.d1, empRef[0]);
            link.put(this.d2, empRef[1]);
            link.put(this.d3, empRef[2]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<Date, Employee2> link2 = new HashMap<Date, Employee2>();
            link2.put(this.d4, empRef2[0]);
            link2.put(this.d5, empRef2[1]);
            deptRef2[0].setLastNameEmployees(link2);
            HashMap<Date, EmbeddedEmployee> link3 = new HashMap<Date, EmbeddedEmployee>();
            link3.put(this.d6, new EmbeddedEmployee(empRef3[0]));
            link3.put(this.d7, new EmbeddedEmployee(empRef3[1]));
            deptRef3[0].setLastNameEmployees(link3);
            this.logTrace("Persist Employee ");
            for (Employee employee : empRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                this.logTrace("persisted Employee " + employee.getId());
            }
            this.logTrace("Persist Employee2 ");
            for (Serializable serializable : empRef2) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted Employee2 " + ((Employee2)serializable).getId());
            }
            this.logTrace("Persist Employee3 ");
            for (Serializable serializable : empRef3) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted Employee3 " + ((Employee4)serializable).getId());
            }
            this.logTrace("Merge Department ");
            for (Serializable serializable : deptRef) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department " + ((Department)serializable).getName());
            }
            this.logTrace("Merge Department2 ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department2 " + ((Department2)serializable).getName());
            }
            this.logTrace("Merge Department3 ");
            for (Serializable serializable : deptRef3) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department3 " + ((Department4)serializable).getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeCustTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }

    private void removeCustTestData() {
        this.logTrace("removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATES_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

