/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.harness.Status;
import java.io.Serializable;

public class RemoteStatus
implements Serializable {
    private static final long serialVersionUID = 3604418904944742426L;
    int type;
    String reason;
    String errorMessage;
    StackTraceElement[] errorTrace;

    public RemoteStatus(Status s) {
        this(s, null);
    }

    public RemoteStatus(Status s, Throwable error) {
        this.type = s.getType();
        this.reason = s.getReason();
        if (error != null) {
            this.errorTrace = error.getStackTrace();
            this.errorMessage = error.getMessage();
            if (this.errorMessage == null) {
                this.errorMessage = error.toString();
            }
        }
    }

    public Status toStatus() {
        return new Status(this.type, this.reason);
    }

    public int getType() {
        return this.type;
    }

    public boolean hasError() {
        return this.errorTrace != null;
    }

    public StackTraceElement[] getErrorTrace() {
        return this.errorTrace;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RemoteStatus: ");
        sb.append(this.toStatus());
        if (this.hasError()) {
            sb.append(" Error: '");
            sb.append(this.errorMessage);
            sb.append("'\n StackTrace:\n");
            for (int i = 0; i < this.errorTrace.length; ++i) {
                sb.append(this.errorTrace[i]);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

