/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.getMessageContent;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="mail"), @Tag(value="platform")})
public class getMessageContent_Test
extends ServiceEETest {
    private int errors = 0;
    private MailTestUtil mailTestUtil;
    private Folder folder;
    private Store store;
    private int msgcount = -1;
    private Status status;
    private String rootPath;

    public void setup(String[] args, Properties props) throws Exception {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            String user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            this.rootPath = TestUtil.getProperty((String)"javamail.root.path");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            MailTestUtil mailTestUtil = new MailTestUtil();
            this.store = mailTestUtil.connect2host(protocol, host, imapPort, user, password);
            Folder root = this.getRootFolder(this.store);
            this.folder = root.getFolder(mailbox);
            if (this.folder == null) {
                throw new Exception("Invalid folder object!");
            }
            this.folder.open(1);
            if (this.msgcount == -1) {
                this.msgcount = this.folder.getMessageCount();
                if (this.msgcount < 1) {
                    throw new Exception("Mail folder is empty!");
                }
            }
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void test1() throws Exception {
        try {
            for (int i = 1; i <= this.msgcount; ++i) {
                TestUtil.logMsg((String)("UNIT TEST " + i + ": getMessage(" + i + ")"));
                Message msg = this.folder.getMessage(i);
                Message cmsg = this.folder.getMessage(i);
                if (msg != null && msg instanceof Message) {
                    int size_in_bytes2;
                    int size_in_bytes1 = msg.getSize();
                    if (size_in_bytes1 != (size_in_bytes2 = cmsg.getSize())) continue;
                    TestUtil.logMsg((String)("UNIT TEST " + i + ": passed\n"));
                    continue;
                }
                TestUtil.logMsg((String)("UNIT TEST " + i + ": FAILED\n"));
                ++this.errors;
            }
            TestUtil.logMsg((String)"\n");
            this.folder.close(false);
            this.store.close();
            this.checkStatus();
            if (this.errors > 0) {
                throw new Exception("test1 Failed: No of unit test failed = " + this.errors);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test1 Failed");
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public void cleanup() throws Exception {
        try {
            this.logMsg("Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }

    public Store connect2host(String proto, String host, String user, String password) {
        Store store = null;
        try {
            TSNamingContext nctx = new TSNamingContext();
            Session session = (Session)nctx.lookup("java:comp/env/mail/MailSession");
            if (session == null) {
                TestUtil.logMsg((String)"Warning: Failed to create a Session object!");
                return null;
            }
            store = session.getStore(proto);
            if (store == null) {
                TestUtil.logMsg((String)"Warning: Failed to create a Store object!");
                return null;
            }
            int portnum = -1;
            if (host != null || user != null || password != null) {
                if (portnum > 0) {
                    store.connect(host, portnum, user, password);
                } else {
                    store.connect(host, user, password);
                }
            } else {
                store.connect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return store;
    }

    public Folder getRootFolder(Store store) {
        Folder folder = null;
        try {
            folder = this.rootPath.equals("") ? store.getDefaultFolder() : store.getFolder(this.rootPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder;
    }
}

