/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.util;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class fpopulate {
    static boolean force = false;
    static boolean skipSCCS = false;
    static boolean clear = false;
    static Session session;

    public static void main(String[] argv) {
        String srcdir = null;
        String dstURL = null;
        boolean debug = false;
        String user = null;
        String password = null;
        String host = null;
        String portStr = null;
        String protocol = null;
        boolean deleteFolder = false;
        for (int optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-s")) {
                srcdir = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-d")) {
                dstURL = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-D")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("-f")) {
                force = true;
                continue;
            }
            if (argv[optind].equals("-S")) {
                skipSCCS = true;
                continue;
            }
            if (argv[optind].equals("-c")) {
                clear = true;
                continue;
            }
            if (argv[optind].equals("-user")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-password")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-host")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-port")) {
                portStr = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-protocol")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-deleteFolder")) {
                deleteFolder = true;
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            fpopulate.printUsage();
            System.exit(1);
        }
        try {
            Folder dstFolder;
            URLName dstURLName;
            if (srcdir == null || dstURL == null) {
                fpopulate.printUsage();
                System.exit(1);
            }
            int imapPort = Integer.parseInt(portStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            MailTestUtil mailTestUtil = new MailTestUtil();
            Store store = mailTestUtil.connect2host(protocol, host, imapPort, user, password);
            session = mailTestUtil.getSession();
            session.setDebug(debug);
            File srcFolder = new File(srcdir);
            if (!srcFolder.exists()) {
                System.out.println("source folder does not exist");
                System.exit(1);
            }
            if ((dstURLName = new URLName(dstURL)).getFile() == null) {
                Store s = session.getStore(dstURLName);
                s.connect();
                dstFolder = s.getFolder(srcFolder.getName());
            } else {
                dstFolder = session.getFolder(new URLName(dstURL));
            }
            if (clear && dstFolder.exists() && !dstFolder.delete(true)) {
                System.out.println("couldn't delete " + dstFolder.getFullName());
                return;
            }
            if (!deleteFolder) {
                fpopulate.copy(srcFolder, dstFolder);
            } else {
                System.out.println("Delete " + dstFolder.getFullName());
            }
            dstFolder.getStore().close();
        }
        catch (MessagingException mex) {
            System.out.println(mex.getMessage());
            mex.printStackTrace();
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
            ioex.printStackTrace();
        }
    }

    private static void copy(File src, Folder dst) throws MessagingException, IOException {
        System.out.println("Populating " + dst.getFullName());
        if (!dst.exists()) {
            int type;
            int n = type = fpopulate.holdsMessages(src) ? 1 : 2;
            if (!dst.create(type)) {
                System.out.println("couldn't create " + dst.getFullName());
                return;
            }
            if (fpopulate.holdsMessages(src)) {
                fpopulate.copyMessages(src, dst);
            }
        } else {
            System.out.println(dst.getFullName() + " already exists");
            if (force && fpopulate.holdsMessages(src)) {
                fpopulate.copyMessages(src, dst);
            }
        }
        if (fpopulate.holdsFolders(src)) {
            String[] sf = src.list();
            for (int i = 0; sf != null && i < sf.length; ++i) {
                File f;
                if (skipSCCS && sf[i].equals("SCCS") || !(f = new File(src, sf[i])).isDirectory()) continue;
                fpopulate.copy(f, dst.getFolder(sf[i]));
            }
        }
    }

    private static boolean holdsMessages(File f) {
        File msg = new File(f, "1");
        return msg.exists();
    }

    private static boolean holdsFolders(File f) {
        return !fpopulate.holdsMessages(f);
    }

    private static void copyMessages(File src, Folder dst) throws MessagingException, IOException {
        File f;
        System.out.println("  Copy from " + String.valueOf(src) + " to " + String.valueOf(dst));
        int msgnum = 1;
        Message[] msgs = new Message[1];
        while ((f = new File(src, String.valueOf(msgnum))).exists()) {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream is = new BufferedInputStream(fis);
            is.mark(1024);
            if (is.read() == 70 && is.read() == 114 && is.read() == 111 && is.read() == 109 && is.read() == 32) {
                int c;
                while ((c = is.read()) != 10 && c != 13 && c != -1) {
                }
                if (c == 13) {
                    is.mark(1);
                    if (is.read() != 10) {
                        is.reset();
                    }
                }
            } else {
                is.reset();
            }
            MimeMessage msg = new MimeMessage(session, (InputStream)is);
            fis.close();
            msgs[0] = msg;
            dst.appendMessages(msgs);
            ++msgnum;
        }
        System.out.println("  Copied " + (msgnum - 1) + " messages");
    }

    private static void printUsage() {
        System.out.println("fpopulate [-D] [-f] [-S] [-c] -s source_dir -d dest_url");
        System.out.println("URLs are of the form: protocol://username:password@hostname/foldername");
        System.out.println("The destination URL does not need a foldername, in which case, the source foldername is used");
    }
}

