/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import com.sun.ts.lib.util.Acceptor;
import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestReportInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public final class TestUtil {
    public static boolean traceflag = true;
    public static String sTestName;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final int VM_UNDER_TEST = 0;
    public static final int VM_HARNESS = 1;
    public static final int VM_JAVATEST = 2;
    public static final int DEBUG_OUTPUT_LEVEL = 2;
    public static final int NORMAL_OUTPUT_LEVEL = 3;
    public static final int ERROR_STREAM = 4;
    public static final int OUTPUT_STREAM = 5;
    public static String NEW_LINE;
    public static int iWhereAreWe;
    private static PrintWriter out;
    private static PrintWriter err;
    private static PrintWriter additionalWriter;
    private static ObjectOutputStream objectOutputStream;
    private static ObjectOutputStream objectInputStream;
    private static Socket socketOnRemoteVM;
    private static boolean bAlreadyInitialized;
    private static Object socketMutex;
    private static int portOfHarness;
    private static String hostOfHarness;
    private static Vector vBuffereredOutput;
    private static final String UNRECOGNIZED_STATUS = "UNRECOGNIZED_STATUS";
    private static final String[] transactionTable;
    public static boolean harnessDebug;
    private static Properties testProps;
    private static SimpleDateFormat df;
    public static final int MILLI = 1000;
    private static final String PROPS_FILE_NAME = "-cts-props.txt";
    private static final String PROPS_FILE;

    public static void logHarnessDebug(String s) {
        if (harnessDebug) {
            TestUtil.logHarness(s, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logHarness(String s, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(df.format(new Date()) + ":  Harness - " + s);
            TestUtil.logToAdditionalWriter(s, t);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static void logHarness(String s) {
        TestUtil.logHarness(s, null);
    }

    private static void logToAdditionalWriter(String s) {
        TestUtil.logToAdditionalWriter(s, null);
    }

    private static void logToAdditionalWriter(String s, Throwable t) {
        if (additionalWriter != null) {
            additionalWriter.println(s);
            if (t != null) {
                t.printStackTrace(additionalWriter);
            }
        }
    }

    public static Properties getProperties() {
        if (testProps == null) {
            testProps = TestUtil.getPropsFromFile();
        }
        return testProps;
    }

    public static String getProperty(String s) {
        Properties p = TestUtil.getProperties();
        return TestUtil.getProperty(p, s);
    }

    public static String getProperty(String s, String defaultValue) {
        Properties p = TestUtil.getProperties();
        return TestUtil.getProperty(p, s, defaultValue);
    }

    public static String getProperty(Properties props, String key) {
        String value = props.getProperty(key);
        if (value == null) {
            TestUtil.logMsg("Test property " + key + " is not set");
        }
        return value;
    }

    public static String getProperty(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            TestUtil.logMsg("Test property " + key + " is not set, using: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            TestUtil.logMsg("System property " + key + " is not set");
        }
        return value;
    }

    public static String getSystemProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static String getTransactionStatus(int status) {
        if (status < 0 || status > transactionTable.length - 1) {
            return UNRECOGNIZED_STATUS;
        }
        return transactionTable[status];
    }

    public static void printTransactionStatus(int status) {
        TestUtil.logMsg("TRANSACTION_STATUS: " + TestUtil.getTransactionStatus(status));
    }

    public static void sleepSec(int s) {
        TestUtil.logTrace("Sleeping " + s + " seconds");
        try {
            Thread.sleep(s * 1000);
        }
        catch (InterruptedException e) {
            TestUtil.logErr("Exception: " + String.valueOf(e));
        }
    }

    public static void sleep(int s) {
        TestUtil.sleepMsec(s);
    }

    public static void sleepMsec(int s) {
        TestUtil.logTrace("Sleeping " + s + " milliseconds");
        try {
            Thread.sleep(s);
        }
        catch (InterruptedException e) {
            TestUtil.logErr("Exception: " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushStream() {
        Object object = socketMutex;
        synchronized (object) {
            try {
                objectOutputStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(TestReportInfo info) {
        Object object = socketMutex;
        synchronized (object) {
            TestUtil.flushStream();
            try {
                objectOutputStream.writeObject(info);
            }
            catch (Exception e) {
                Vector vector = vBuffereredOutput;
                synchronized (vector) {
                    vBuffereredOutput.addElement(info);
                }
            }
            TestUtil.flushStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendBufferedData() throws Exception {
        TestReportInfo tri = null;
        Vector vector = vBuffereredOutput;
        synchronized (vector) {
            try {
                Object object = socketMutex;
                synchronized (object) {
                    for (int ii = 0; ii < vBuffereredOutput.size(); ++ii) {
                        tri = (TestReportInfo)vBuffereredOutput.elementAt(ii);
                        TestUtil.writeObject(tri);
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                vBuffereredOutput.removeAllElements();
            }
        }
    }

    private static Properties getPropsFromFile() {
        FileInputStream in = null;
        Properties p = new Properties();
        try {
            in = new FileInputStream(PROPS_FILE);
            p.load(in);
        }
        catch (Exception e) {
            TestUtil.logErr("Error reading the Properties object", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return p;
    }

    private static void savePropsToFile(Properties p) {
        try (FileOutputStream out = new FileOutputStream(PROPS_FILE);){
            p.store(out, "CTS Test Properties File");
        }
        catch (Exception e) {
            TestUtil.logErr("Error saving the Properties object", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Properties p) throws RemoteLoggingInitException {
        TestUtil.savePropsToFile(p);
        Object object = socketMutex;
        synchronized (object) {
            try {
                testProps = p;
                if (p.isEmpty()) {
                    throw new RemoteLoggingInitException("Init: Error - Empty properties object passed to TestUtil.init");
                }
                NEW_LINE = p.getProperty("line.separator");
                if (socketOnRemoteVM != null) {
                    socketOnRemoteVM.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                traceflag = Boolean.parseBoolean(p.getProperty("harness.log.traceflag", "true"));
                hostOfHarness = p.getProperty("harness.host");
                portOfHarness = Integer.parseInt(p.getProperty("harness.log.port", "2000"));
                if (hostOfHarness == null) {
                    throw new RemoteLoggingInitException("Init: Error while trying to getProperty(harness.host) - returned null");
                }
                socketOnRemoteVM = new Socket(hostOfHarness, portOfHarness);
                objectOutputStream = new ObjectOutputStream(socketOnRemoteVM.getOutputStream());
                TestUtil.sendBufferedData();
            }
            catch (UnknownHostException e) {
                throw new RemoteLoggingInitException("You must pass a valid host string to init()");
            }
            catch (IOException e) {
                try {
                    traceflag = Boolean.parseBoolean(p.getProperty("harness.log.traceflag", "true"));
                    hostOfHarness = p.getProperty("harness.host");
                    portOfHarness = Integer.parseInt(p.getProperty("harness.log.port", "2000"));
                    if (hostOfHarness == null) {
                        throw new RemoteLoggingInitException("Init: Error while trying to getProperty(harness.host) - returned null");
                    }
                    if (socketOnRemoteVM != null) {
                        socketOnRemoteVM.close();
                    }
                    socketOnRemoteVM = new Socket(hostOfHarness, portOfHarness);
                    objectOutputStream = new ObjectOutputStream(socketOnRemoteVM.getOutputStream());
                    TestUtil.sendBufferedData();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new RemoteLoggingInitException("IOException in TestUtil.init()");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new RemoteLoggingInitException("got a random exception in init()");
                }
            }
            catch (NumberFormatException e) {
                throw new RemoteLoggingInitException("You must pass a valid port number string to init()");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteLoggingInitException("got a random exception in init()");
            }
        }
    }

    public static void initJavaTest() {
        iWhereAreWe = 2;
    }

    public static void setAdditionalWriter(PrintWriter pw) {
        iWhereAreWe = 2;
        additionalWriter = pw;
    }

    public static void initNoLogging(Properties p) {
        if (bAlreadyInitialized) {
            return;
        }
        testProps = p;
        NEW_LINE = p.getProperty("line.separator");
        traceflag = Boolean.parseBoolean(p.getProperty("harness.log.traceflag", "true"));
        iWhereAreWe = 1;
        bAlreadyInitialized = true;
    }

    public static void initClient(Properties p) {
        if (bAlreadyInitialized) {
            return;
        }
        try {
            testProps = p;
            NEW_LINE = p.getProperty("line.separator");
            traceflag = Boolean.parseBoolean(p.getProperty("harness.log.traceflag", "true"));
            iWhereAreWe = 1;
            ServerSocket ss = TestUtil.getServerSocket(p);
            new Acceptor(ss);
            bAlreadyInitialized = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ServerSocket getServerSocket(Properties p) throws IOException {
        ServerSocket result = null;
        int port = 2000;
        int retry = 10;
        boolean delaySeconds = true;
        try {
            port = Integer.parseInt(p.getProperty("harness.log.port", "2000"));
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
            System.err.println("Invalid value for harness.log.port, using default harness.log.port of " + port);
        }
        try {
            retry = Integer.parseInt(p.getProperty("harness.socket.retry.count", "10"));
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
            System.err.println("Invalid value for harness.socket.retry.count, using default harness.socket.retry.count of " + retry);
        }
        TestUtil.logTrace("#######  Value of harness.socket.retry.count is \"" + retry + "\"");
        TestUtil.logTrace("#######  Value of harness.log.port is \"" + port + "\"");
        result = TestUtil.getServerSocket0(port, retry, 1);
        while (result == null) {
            result = TestUtil.getServerSocket0(++port, retry, 1);
        }
        p.setProperty("harness.log.port", Integer.toString(port));
        TestUtil.logTrace("#######  Actual bind value of harness.log.port is \"" + port + "\"");
        return result;
    }

    private static ServerSocket getServerSocket0(int port, int retry, int delaySeconds) {
        ServerSocket result = null;
        for (int i = 0; i < retry; ++i) {
            try {
                result = new ServerSocket(port);
                break;
            }
            catch (IOException e3) {
                try {
                    Thread.sleep(delaySeconds * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return result;
    }

    public static void setCurrentTest(String testName, PrintWriter outStream, PrintWriter errStream) {
        sTestName = testName;
        out = outStream;
        err = outStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(String s) {
        if (iWhereAreWe == 2) {
            TestUtil.logHarness(s);
        } else if (iWhereAreWe == 1) {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.println(df.format(new Date()) + ":  " + s);
                out.flush();
            }
        } else {
            TestReportInfo tri = new TestReportInfo("SVR: " + s, 5, 3, null);
            TestUtil.writeObject(tri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMsg(String s, Throwable t) {
        if (iWhereAreWe == 2) {
            TestUtil.logHarnessDebug(s);
            if (t != null) {
                t.printStackTrace();
            }
        } else {
            if (iWhereAreWe == 1) {
                PrintWriter printWriter = out;
                synchronized (printWriter) {
                    out.println(df.format(new Date()) + ":  " + s);
                    out.flush();
                }
            } else {
                TestReportInfo tri = new TestReportInfo("SVR: " + s, 5, 3, null);
                TestUtil.writeObject(tri);
            }
            if (t != null) {
                TestUtil.printStackTrace(t);
            }
        }
    }

    public static void setTrace(boolean b) {
        traceflag = b;
    }

    public static void logTrace(String s) {
        TestUtil.logTrace(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logTrace(String s, Throwable t) {
        if (traceflag) {
            if (iWhereAreWe == 2) {
                TestUtil.logHarnessDebug(s);
            } else if (iWhereAreWe == 1) {
                PrintWriter printWriter = out;
                synchronized (printWriter) {
                    if (s != null && s.startsWith("SVR-TRACE")) {
                        out.println(df.format(new Date()) + ":  " + s);
                    } else {
                        out.println(df.format(new Date()) + ":  TRACE: " + s);
                    }
                }
            } else {
                TestReportInfo tri = new TestReportInfo("SVR-TRACE: " + s, 5, 2, null);
                TestUtil.writeObject(tri);
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logErr(String s, Throwable e) {
        if (iWhereAreWe == 2) {
            TestUtil.logHarness(s);
            if (e != null) {
                e.printStackTrace();
            }
        } else {
            if (iWhereAreWe == 1) {
                PrintWriter printWriter = err;
                synchronized (printWriter) {
                    if (s != null && s.startsWith("SVR-ERROR")) {
                        err.println(df.format(new Date()) + ":  " + s);
                    } else {
                        err.println(df.format(new Date()) + ":  ERROR: " + s);
                    }
                }
            } else {
                TestReportInfo tri = new TestReportInfo("SVR-ERROR: " + s, 4, 3, null);
                TestUtil.writeObject(tri);
            }
            if (e != null) {
                TestUtil.printStackTrace(e);
            }
        }
    }

    public static void logErr(String s) {
        TestUtil.logErr(s, null);
    }

    public static void list(Properties p) {
        StringBuffer sb = new StringBuffer();
        if (p == null) {
            return;
        }
        sb.append("--- Property Listing ---").append(NEW_LINE);
        Enumeration<?> e = p.propertyNames();
        String key = null;
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            sb.append(key).append("=").append(p.getProperty(key)).append(NEW_LINE);
        }
        sb.append("--- End Property Listing ---").append(NEW_LINE);
        TestUtil.logTrace(new String(sb));
    }

    public static void printStackTrace(Throwable e) {
        if (e == null) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            TestUtil.logErr(sw.toString());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String printStackTraceToString(Throwable e) {
        String sTrace = "";
        if (e == null) {
            return "";
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            sTrace = sw.toString();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sTrace;
    }

    public static void separator2() {
        TestUtil.logMsg("********************************************************************************");
    }

    public static void separator1() {
        TestUtil.logMsg("--------------------------------------------------------------------------------");
    }

    public static String getResponse(URLConnection connection) throws IOException {
        InputStream instream = connection.getInputStream();
        InputStreamReader inreader = new InputStreamReader(instream);
        BufferedReader in = new BufferedReader(inreader);
        StringBuffer content = new StringBuffer(1024);
        char[] chars = new char[1024];
        int length = 0;
        while (length != -1) {
            content.append(chars, 0, length);
            length = in.read(chars, 0, chars.length);
        }
        instream.close();
        inreader.close();
        in.close();
        return content.toString();
    }

    public static Properties getResponseProperties(String string) throws IOException {
        Properties props = new Properties();
        byte[] bytes = string.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        props.load(in);
        in.close();
        return props;
    }

    public static Properties getResponseProperties(URLConnection connection) throws IOException {
        String input = TestUtil.getResponse(connection);
        Properties props = TestUtil.getResponseProperties(input);
        return props;
    }

    public static String toEncodedString(Properties args) {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            buf.append(URLEncoder.encode(name)).append("=").append(URLEncoder.encode(value));
            if (!names.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }

    public static URLConnection sendPostData(Properties p, URL url) throws IOException {
        TestUtil.logMsg("Openning url connection to: " + url.toString());
        URLConnection urlConn = url.openConnection();
        String argString = TestUtil.toEncodedString(p);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        DataOutputStream out = new DataOutputStream(urlConn.getOutputStream());
        out.writeBytes(argString);
        out.flush();
        out.close();
        return urlConn;
    }

    public static String getTableName(String value) {
        String tableName = "";
        if (value != null) {
            tableName = value.trim();
            int pos = tableName.lastIndexOf(" ");
            tableName = tableName.substring(pos + 1);
        } else {
            TestUtil.logMsg("Error: Null value passed for table Name");
        }
        return tableName;
    }

    public static String srcToDist(String src) {
        return TestUtil.replaceLastSrc(src, "dist");
    }

    public static String replaceLastSrc(String src, String replacement) {
        StringBuffer sbToConvert = new StringBuffer(src);
        int iStart = src.lastIndexOf("src");
        if (iStart != -1) {
            if (harnessDebug) {
                TestUtil.logHarnessDebug("Pre-converted src dir = " + String.valueOf(sbToConvert));
            }
            sbToConvert.replace(iStart, iStart + 3, replacement);
            if (harnessDebug) {
                TestUtil.logHarnessDebug("Converted " + replacement + " dir = " + String.valueOf(sbToConvert));
            }
        }
        return sbToConvert.toString();
    }

    public static String getDistString() {
        return "dist";
    }

    public static String getRelativePath(String oldVal) {
        if (oldVal == null) {
            return oldVal;
        }
        String result = oldVal;
        oldVal = oldVal.replace('\\', '/');
        while (oldVal.endsWith("/")) {
            oldVal = oldVal.substring(0, oldVal.length() - 1);
        }
        if (oldVal.endsWith("/src")) {
            return result;
        }
        int pos = oldVal.indexOf("/src/");
        result = pos == -1 ? ((pos = oldVal.indexOf("/dist/")) == -1 ? oldVal : oldVal.substring(pos + 6)) : oldVal.substring(pos + 5);
        return result;
    }

    public static Properties strToProps(String strProps) {
        String[] strArray;
        TestUtil.logTrace("Props String = " + strProps);
        Properties props = new Properties();
        for (String keyValuePair : strArray = strProps.split(":")) {
            String[] strArray2 = keyValuePair.split("=");
            TestUtil.logTrace("Setting property " + strArray2[0] + " = " + strArray2[1]);
            props.setProperty(strArray2[0], strArray2[1]);
        }
        return props;
    }

    public static void printProperties(Properties props) {
        Set<String> propertyNames = props.stringPropertyNames();
        for (String key : propertyNames) {
            TestUtil.logTrace(key + " = " + props.getProperty(key));
        }
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
        NEW_LINE = System.getProperty("line.separator", "\n");
        iWhereAreWe = 0;
        out = null;
        err = null;
        additionalWriter = null;
        objectOutputStream = null;
        objectInputStream = null;
        socketOnRemoteVM = null;
        bAlreadyInitialized = false;
        socketMutex = new Object();
        portOfHarness = 2000;
        hostOfHarness = "unset host";
        vBuffereredOutput = new Vector();
        transactionTable = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};
        testProps = null;
        df = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        harnessDebug = Boolean.getBoolean("cts.harness.debug");
        String userName = System.getProperty("user.name");
        String tmpDir = System.getProperty("java.io.tmpdir", File.separator + "tmp");
        PROPS_FILE = tmpDir.endsWith(File.separator) ? tmpDir + userName + PROPS_FILE_NAME : tmpDir + File.separator + userName + PROPS_FILE_NAME;
        System.out.println("************************************************************");
        System.out.println("* props file set to \"" + PROPS_FILE + "\"");
        System.out.println("************************************************************");
    }
}

