/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.TSeis;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private TSManagedConnection mc;
    private int seconds = 0;
    private Hashtable xidset = null;

    public XAResourceImpl(TSManagedConnection mc) {
        this.mc = mc;
        this.xidset = new Hashtable();
        if (mc == null) {
            System.out.println("TSManagedConnection is null in XAResourceImpl");
        }
    }

    private void handleResourceException(Exception ex) throws XAException {
        XAException xae = new XAException(ex.toString());
        xae.errorCode = -3;
        throw xae;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            System.out.println("XAResourceImpl.commit");
            ConnectorStatus.getConnectorStatus().logAPI("XAResourceImpl.commit", "", "");
            TSeis.getTSeis().getResourceManager().commit(xid, onePhase);
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            System.out.println("XAResourceImpl.start");
            TSeis.getTSeis().getResourceManager().start(xid, flags, this.mc.getTSConnection());
            ConnectorStatus.getConnectorStatus().logAPI("XAResourceImpl.start", "", "");
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            System.out.println("XAResourceImpl.end");
            TSeis.getTSeis().getResourceManager().end(xid, flags);
            ConnectorStatus.getConnectorStatus().logAPI("XAResourceImpl.end", "", "");
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        System.out.println("XAResourceImpl.forget");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.seconds;
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        System.out.println("XAResourceImpl.isSameRM");
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof XAResourceImpl && this.mc != null) {
            XAResourceImpl obj = (XAResourceImpl)other;
            return this.mc.equals(obj.mc);
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        ConnectorStatus.getConnectorStatus().logAPI("XAResourceImpl.prepare", "", "");
        System.out.println("XAResourceImpl.prepare");
        try {
            return TSeis.getTSeis().getResourceManager().prepare(xid);
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
            return -3;
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        System.out.println("XAResourceImpl.recover");
        return null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            System.out.println("XAResourceImpl.rollback");
            TSeis.getTSeis().getResourceManager().rollback(xid);
            ConnectorStatus.getConnectorStatus().logAPI("XAResourceImpl.rollback", "", "");
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.seconds = seconds;
        return true;
    }
}

