/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ParameterFilter
extends ObservableTestFilter {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock rl = this.rwl.readLock();
    private final Lock wl = this.rwl.writeLock();
    private InitialUrlFilter iurlFilter;
    private String lastInitStrings;
    private TestFilter[] filters;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ParameterFilter.class);

    @Override
    public String getName() {
        return i18n.getString("pFilter.name");
    }

    @Override
    public String getDescription() {
        return i18n.getString("pFilter.desc");
    }

    @Override
    public String getReason() {
        return i18n.getString("pFilter.reason");
    }

    @Override
    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        return this.accepts(td, null);
    }

    @Override
    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        return this.accepts(td, null, o);
    }

    @Override
    public boolean accepts(TestResult tr, TestFilter.Observer o) throws TestFilter.Fault {
        try {
            TestDescription td = tr.getDescription();
            return this.accepts(td, tr, o);
        }
        catch (TestResult.Fault f) {
            throw new TestFilter.Fault(i18n, "pFilter.trNoTd", f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accepts(TestDescription td, TestResult tr, TestFilter.Observer o) throws TestFilter.Fault {
        this.rl.lock();
        try {
            if (this.filters == null || this.filters.length == 0) {
                if (this.iurlFilter == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean result = this.iurlFilter.accepts(td);
                if (!result && o != null) {
                    o.rejected(td, this.iurlFilter);
                }
            }
            for (int i = 0; i < this.filters.length; ++i) {
                boolean result = false;
                if (tr != null && this.filters[i] instanceof StatusFilter) {
                    try {
                        result = this.filters[i].accepts(tr);
                    }
                    catch (TestResult.Fault f) {
                        result = this.filters[i].accepts(td);
                    }
                } else {
                    result = this.filters[i].accepts(td);
                }
                if (result) continue;
                if (o != null) {
                    o.rejected(td, this.filters[i]);
                }
                boolean bl = false;
                return bl;
            }
            if (this.iurlFilter != null && !this.iurlFilter.accepts(td)) {
                if (o != null) {
                    o.rejected(td, this.iurlFilter);
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.rl.unlock();
        }
        return true;
    }

    public TestFilter[] getTestFilters() {
        TestFilter[] copy = null;
        this.rl.lock();
        try {
            if (this.iurlFilter != null) {
                copy = new TestFilter[this.filters.length + 1];
                copy[copy.length - 1] = this.iurlFilter;
            } else {
                copy = new TestFilter[this.filters.length];
            }
            System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        }
        finally {
            this.rl.unlock();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Parameters p) {
        this.wl.lock();
        boolean wasUpdated = false;
        try {
            if (p == null) {
                boolean isUpdated = this.filters != null;
                this.filters = null;
                this.iurlFilter = null;
                if (isUpdated) {
                    this.notifyUpdated(this);
                }
                return;
            }
            TestFilter[] newFilters = p.getFilters();
            if (newFilters != null || this.filters != null) {
                if (newFilters == null && this.filters != null || this.filters == null && newFilters != null) {
                    this.filters = newFilters;
                    wasUpdated = true;
                } else if (newFilters.length == this.filters.length) {
                    if (!CompositeFilter.equals(newFilters, this.filters)) {
                        this.filters = newFilters;
                        wasUpdated = true;
                    }
                } else {
                    this.filters = newFilters;
                    wasUpdated = true;
                }
            }
            String[] initStrings = p.getTests();
            File[] initFiles = ParameterFilter.stringsToFiles(initStrings);
            this.iurlFilter = new InitialUrlFilter(initFiles);
            wasUpdated = wasUpdated || !StringArray.join(initStrings).equals(this.lastInitStrings);
            this.lastInitStrings = StringArray.join(initStrings);
        }
        finally {
            this.wl.unlock();
        }
        if (wasUpdated) {
            this.notifyUpdated(this);
        }
    }

    public InitialUrlFilter getIUrlFilter() {
        return this.iurlFilter;
    }

    private static File[] stringsToFiles(String[] tests) {
        if (tests == null) {
            return null;
        }
        File[] files = new File[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            files[i] = new File(tests[i]);
        }
        return files;
    }
}

