/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.protocol.data;

import com.gargoylesoftware.htmlunit.protocol.data.DataUrlDecoder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataURLConnection
extends URLConnection {
    private static final Log LOG = LogFactory.getLog(DataURLConnection.class);
    public static final String DATA_PREFIX = "data:";
    private final byte[] content_;

    public DataURLConnection(URL url) {
        super(url);
        byte[] data = null;
        try {
            data = DataUrlDecoder.decode(url).getBytes();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Exception decoding " + url), (Throwable)e);
        }
        catch (DecoderException e) {
            LOG.error((Object)("Exception decoding " + url), (Throwable)e);
        }
        this.content_ = data;
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content_);
    }
}

