/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.loaders;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.AnnotationItemEx;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.LRUCache;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryClassDescrLoader
implements ClassDescriptionLoader,
LoadingHints {
    public static final boolean ANNOTATION_DEFAULT_VALUES_ON = true;
    private final BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
    private boolean ignoreAnnotations = false;
    private final Classpath classpath;
    private final LRUCache<String, BinaryClassDescription> cache;
    private final Map<String, BinaryClassDescription> stack = new HashMap<String, BinaryClassDescription>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BinaryClassDescrLoader.class);
    private static final int MAGIC = -889275714;
    private static final int TIGER_CLASS_VERSION = 49;
    private static final int J7_CLASS_VERSION = 51;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_Dynamic = 17;
    private static final int CONSTANT_InvokeDynamic = 18;
    private static final int CONSTANT_ModuleId = 19;
    private static final int CONSTANT_ModuleQuery = 20;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Set<LoadingHints.Hint> hints = new HashSet<LoadingHints.Hint>();
    private PrintWriter log;
    private final Set<String> notFoundAnnotations = new HashSet<String>();

    public BinaryClassDescrLoader(Classpath classpath, Integer bufferSize) {
        this.classpath = classpath;
        this.cache = new LRUCache(bufferSize);
    }

    @Override
    public ClassDescription load(String className) throws ClassNotFoundException {
        className = ExoticCharTools.decodeExotic(className);
        assert (className.indexOf(60) == -1) : className;
        BinaryClassDescription c = (BinaryClassDescription)this.cache.get(className);
        if (c != null) {
            return c;
        }
        c = this.stack.get(className);
        if (c != null) {
            return c;
        }
        InputStream is = null;
        try {
            c = new BinaryClassDescription();
            this.stack.put(className, c);
            is = this.classpath.findClass(className);
            this.readClass(c, is, className);
            this.cache.put(className, c);
        }
        catch (IOException e) {
            if (this.bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            throw new ClassNotFoundException(className);
        }
        finally {
            this.stack.remove(className);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return c;
    }

    public ClassDescription altLoad(String className) throws ClassNotFoundException {
        block3: {
            Classpath cp = AppContext.getContext().getInputClasspath();
            if (cp != null) {
                try {
                    return cp.findClassDescription(className);
                }
                catch (ClassNotFoundException e) {
                    ClassDescriptionLoader l = AppContext.getContext().getClassLoader();
                    if (l == null) break block3;
                    return l.load(className);
                }
            }
        }
        throw new ClassNotFoundException(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClass(BinaryClassDescription c, InputStream is, String className) throws IOException {
        DataInputStream classData = new DataInputStream(is);
        try {
            this.readClass(c, classData);
        }
        catch (Throwable t) {
            System.err.println(i18n.getString("BinaryClassDescrLoader.error.classname", className));
            SwissKnife.reportThrowable(t);
        }
        finally {
            c.cleanup();
            is.close();
        }
    }

    private void readClass(BinaryClassDescription c, DataInput classData) throws IOException {
        int magic = classData.readInt();
        if (magic != -889275714) {
            Object[] invargs = new String[]{Integer.toString(magic), Integer.toString(-889275714)};
            throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.magicnum", invargs));
        }
        c.minor_version = classData.readUnsignedShort();
        c.major_version = classData.readUnsignedShort();
        c.setTiger(c.major_version >= 49);
        c.readCP(classData);
        int flags = classData.readUnsignedShort();
        c.setModifiers(flags);
        String clName = c.getClassName(classData.readUnsignedShort());
        c.setupClassName(clName, "");
        String s = c.getClassName(classData.readUnsignedShort());
        if (s != null && !c.hasModifier(Modifier.INTERFACE)) {
            SuperClass superClass = new SuperClass();
            superClass.setupClassName(s);
            c.setSuperClass(superClass);
        }
        String fqname = c.getQualifiedName();
        int n = classData.readUnsignedShort();
        c.createInterfaces(n);
        for (int i = 0; i < n; ++i) {
            s = c.getClassName(classData.readUnsignedShort());
            SuperInterface fid = new SuperInterface();
            fid.setupGenericClassName(s);
            fid.setDirect(true);
            c.setInterface(i, fid);
        }
        this.readFields(c, classData);
        this.readMethods(c, classData);
        ClassAttrs attrs = new ClassAttrs();
        attrs.read(c, classData);
        c.setAnnoList(AnnotationItem.toArray(attrs.annolist));
        SignatureParser parser = null;
        if (c.major_version >= 49) {
            ClassDescription.TypeParameterList tp = null;
            String declaringClass = c.getDeclaringClassName();
            if (!"".equals(declaringClass)) {
                Classpath.KIND_CLASS_DATA k = this.classpath.isClassPresent(declaringClass);
                if (k == Classpath.KIND_CLASS_DATA.NOT_FOUND) {
                    c.setNoDeclaringClass();
                    this.warning(i18n.getString("BinaryClassDescrLoader.error.enclosing_class_not_found", c.getQualifiedName()));
                } else {
                    try {
                        ClassDescription enc;
                        if (k == Classpath.KIND_CLASS_DATA.DESCRIPTION) {
                            enc = this.classpath.findClassDescription(declaringClass);
                        } else {
                            try {
                                enc = this.load(declaringClass);
                            }
                            catch (ClassNotFoundException ex) {
                                enc = this.altLoad(declaringClass);
                            }
                        }
                        tp = enc.getTypeparamList();
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.enclosing", fqname));
                    }
                }
            }
            ClassDescription.TypeParameterList typeparamList = new ClassDescription.TypeParameterList(tp);
            c.setTypeparamList(typeparamList);
            parser = new SignatureParser(fqname, typeparamList);
        }
        if (parser != null) {
            if (attrs.signature != null) {
                try {
                    parser.scanClass(attrs.signature);
                    c.setTypeParameters(parser.generic_pars);
                    SuperClass superClass = c.getSuperClass();
                    if (superClass != null) {
                        superClass.setupGenericClassName(parser.class_supr);
                    }
                    int num = parser.class_intfs.size();
                    c.createInterfaces(num);
                    for (int i = 0; i < num; ++i) {
                        SuperInterface fid = new SuperInterface();
                        fid.setupGenericClassName(parser.class_intfs.get(i));
                        fid.setDirect(true);
                        c.setInterface(i, fid);
                    }
                }
                catch (SigAttrError e) {
                    this.warning(e.getMessage());
                }
            }
            this.postFields(c, parser);
            this.postMethods(c, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberDescription> loadCalls(String name) throws ClassNotFoundException {
        List<MemberDescription> result;
        try {
            BinaryClassDescription c = new BinaryClassDescription();
            try (DataInputStream classData = new DataInputStream(this.classpath.findClass(name));){
                this.readClass(c, classData);
                result = c.getMethodRefs();
            }
            finally {
                c.cleanup();
            }
        }
        catch (Throwable e) {
            if (this.bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            throw new ClassNotFoundException(name, e);
        }
        return result;
    }

    private void readFields(BinaryClassDescription c, DataInput classData) throws IOException {
        int n = classData.readUnsignedShort();
        ArrayList<FieldDescr> flds = new ArrayList<FieldDescr>();
        ArrayList<String> tmpflds = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            int mod = classData.readUnsignedShort();
            FieldDescr fid = new FieldDescr(c.getName(classData.readUnsignedShort()), c.getQualifiedName(), mod);
            String type = BinaryClassDescrLoader.convertVMType(c.getName(classData.readUnsignedShort()));
            fid.setType(type);
            FieldAttrs attrs = new FieldAttrs();
            attrs.read(c, classData);
            if (!this.hasHint(LoadingHints.READ_SYNTETHIC) && fid.hasModifier(Modifier.ACC_SYNTHETIC)) {
                if (!this.bo.isSet(Option.DEBUG)) continue;
                this.getLog().println(i18n.getString("BinaryClassDescrLoader.message.synthetic_field_skipped", fid.getType() + " " + fid.getQualifiedName()));
                continue;
            }
            flds.add(fid);
            fid.setAnnoList(AnnotationItem.toArray(attrs.annolist));
            tmpflds.add(attrs.signature);
            if (!fid.isFinal() || attrs.value == null) continue;
            switch (type) {
                case "boolean": {
                    attrs.value = (Integer)attrs.value != 0;
                    break;
                }
                case "byte": {
                    attrs.value = ((Integer)attrs.value).byteValue();
                    break;
                }
                case "char": {
                    attrs.value = Character.valueOf((char)((Integer)attrs.value).shortValue());
                }
            }
            fid.setConstantValue(MemberDescription.valueToString(attrs.value));
        }
        n = flds.size();
        if (n != 0) {
            c.setFields(flds.toArray(FieldDescr.EMPTY_ARRAY));
            BinaryClassDescription.access$1302(c, tmpflds.toArray(EMPTY_STRING_ARRAY));
        }
    }

    private void postFields(BinaryClassDescription c, SignatureParser parser) {
        if (c.sigfields != null) {
            for (int i = 0; i < c.sigfields.length; ++i) {
                String sig = c.sigfields[i];
                if (sig == null) continue;
                try {
                    parser.scanField(sig);
                    c.getField(i).setType(parser.field_type);
                    continue;
                }
                catch (SigAttrError e) {
                    this.warning(e.getMessage());
                }
            }
        }
    }

    private void readMethods(BinaryClassDescription c, DataInput classData) throws IOException {
        ArrayList<MemberDescription> ctors = new ArrayList<MemberDescription>();
        ArrayList<MemberDescription> mthds = new ArrayList<MemberDescription>();
        ArrayList<String> tmpctors = new ArrayList<String>();
        ArrayList<String> tmpmthds = new ArrayList<String>();
        int n = classData.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int modif = classData.readUnsignedShort();
            String methodName = c.getName(classData.readUnsignedShort());
            boolean isConstructor = "<init>".equals(methodName);
            MemberDescription memberD = isConstructor ? new ConstructorDescr(c, modif) : new MethodDescr(methodName, c.getQualifiedName(), modif);
            boolean isBridgeMethod = memberD.hasModifier(Modifier.BRIDGE);
            boolean isSynthetic = memberD.hasModifier(Modifier.ACC_SYNTHETIC);
            String descr = c.getName(classData.readUnsignedShort());
            int pos = descr.indexOf(41);
            try {
                memberD.setArgs(BinaryClassDescrLoader.getArgs(descr.substring(1, pos)));
            }
            catch (IllegalArgumentException e) {
                this.err(i18n.getString("BinaryClassDescrLoader.message.incorrectformat", c.getQualifiedName()));
            }
            memberD.setType(BinaryClassDescrLoader.convertVMType(descr.substring(pos + 1)));
            MethodAttrs attrs = new MethodAttrs();
            attrs.read(c, classData);
            if (!this.hasHint(LoadingHints.READ_SYNTETHIC) && isSynthetic) {
                if (!this.bo.isSet(Option.DEBUG)) continue;
                if (isConstructor) {
                    this.getLog().println(i18n.getString("BinaryClassDescrLoader.message.synthetic_constr_skipped", memberD.getQualifiedName() + "(" + memberD.getArgs() + ")"));
                    continue;
                }
                String signature = memberD.getType() + " " + memberD.getQualifiedName() + "(" + memberD.getArgs() + ")";
                if (isBridgeMethod) {
                    this.getLog().println(i18n.getString("BinaryClassDescrLoader.message.bridge", signature));
                    continue;
                }
                this.getLog().println(i18n.getString("BinaryClassDescrLoader.message.synthetic_method_skipped", signature));
                continue;
            }
            if (attrs.annodef != null) {
                memberD.addModifier(Modifier.HASDEFAULT);
                ((MethodDescr)memberD).setAnnoDef(attrs.annodef);
            }
            memberD.setThrowables(MemberDescription.getThrows(attrs.xthrows));
            if (isConstructor) {
                memberD.setType("");
                ctors.add(memberD);
                tmpctors.add(attrs.signature);
            } else if (!"<clinit>".equals(memberD.getName())) {
                mthds.add(memberD);
                tmpmthds.add(attrs.signature);
            }
            memberD.setAnnoList(AnnotationItem.toArray(attrs.annolist));
        }
        n = ctors.size();
        if (n != 0) {
            c.setConstructors(ctors.toArray(ConstructorDescr.EMPTY_ARRAY));
            BinaryClassDescription.access$1502(c, tmpctors.toArray(EMPTY_STRING_ARRAY));
        }
        if ((n = mthds.size()) != 0) {
            c.setMethods(mthds.toArray(MethodDescr.EMPTY_ARRAY));
            BinaryClassDescription.access$1602(c, tmpmthds.toArray(EMPTY_STRING_ARRAY));
        }
    }

    private void postMethods(BinaryClassDescription cls, SignatureParser parser) {
        String sig;
        int i;
        if (cls.sigctors != null) {
            for (i = 0; i < cls.sigctors.length; ++i) {
                sig = cls.sigctors[i];
                if (sig == null) continue;
                try {
                    parser.scanMethod(sig);
                    ConstructorDescr c = cls.getConstructor(i);
                    this.postMethod(parser, c);
                    c.setType("");
                    continue;
                }
                catch (SigAttrError e) {
                    this.warning(e.getMessage());
                }
            }
        }
        if (cls.sigmethods != null) {
            for (i = 0; i < cls.sigmethods.length; ++i) {
                sig = cls.sigmethods[i];
                if (sig == null) continue;
                try {
                    if (this.isAnonimouseSimple(cls)) continue;
                    parser.scanMethod(sig);
                    this.postMethod(parser, cls.getMethod(i));
                    continue;
                }
                catch (SigAttrError e) {
                    this.warning(e.getMessage());
                }
            }
        }
    }

    private boolean isAnonimouseSimple(ClassDescription cls) {
        return Character.isDigit(cls.getName().charAt(0));
    }

    private void postMethod(SignatureParser parser, MemberDescription fid) {
        int i;
        fid.setTypeParameters(parser.generic_pars);
        fid.setType(parser.field_type);
        StringBuffer sb = new StringBuffer();
        if (parser.method_args != null && !parser.method_args.isEmpty()) {
            sb.append(parser.method_args.get(0));
            for (i = 1; i < parser.method_args.size(); ++i) {
                sb.append(",").append(parser.method_args.get(i));
            }
        }
        fid.setArgs(sb.toString());
        sb.setLength(0);
        if (parser.method_throws != null && !parser.method_throws.isEmpty()) {
            sb.append(parser.method_throws.get(0));
            for (i = 1; i < parser.method_throws.size(); ++i) {
                sb.append(",").append(parser.method_throws.get(i));
            }
            fid.setThrowables(sb.toString());
        }
    }

    private static String getArgs(String descr) throws IllegalArgumentException {
        if (descr.isEmpty()) {
            return descr;
        }
        int pos = 0;
        int lastPos = descr.length();
        StringBuffer args = new StringBuffer();
        int dims = 0;
        while (pos < lastPos) {
            String type;
            char ch = descr.charAt(pos);
            if (ch == 'L') {
                int delimPos = descr.indexOf(59, pos);
                if (delimPos == -1) {
                    delimPos = lastPos;
                }
                type = BinaryClassDescrLoader.convertVMType(descr.substring(pos, delimPos + 1));
                pos = delimPos + 1;
            } else {
                if (ch == '[') {
                    ++dims;
                    ++pos;
                    continue;
                }
                type = PrimitiveTypes.getPrimitiveType(ch);
                ++pos;
            }
            args.append(type);
            for (int i = 0; i < dims; ++i) {
                args.append("[]");
            }
            dims = 0;
            if (pos >= lastPos) continue;
            args.append(',');
        }
        return args.toString();
    }

    static String convertVMType(String s) {
        return MemberDescription.getTypeName(s.replace('/', '.'));
    }

    private void err(String s) {
        throw new ClassFormatError(s == null ? "???" : s);
    }

    public void warning(String msg) {
        this.getLog().println(msg);
    }

    public void setIgnoreAnnotations(boolean value) {
        this.ignoreAnnotations = value;
    }

    @Override
    public void addLoadingHint(LoadingHints.Hint hint) {
        this.hints.add(hint);
    }

    private boolean hasHint(LoadingHints.Hint hint) {
        return this.hints.contains(hint);
    }

    private PrintWriter getLog() {
        if (this.log == null) {
            this.log = new PrintWriter(System.err);
        }
        return this.log;
    }

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    private static class SigAttrError
    extends Error {
        SigAttrError(String msg) {
            super(msg);
        }
    }

    static class SignatureParser {
        String generic_pars;
        String class_supr;
        List<String> class_intfs;
        String field_type;
        List<String> method_args;
        List<String> method_throws;
        final String ownname;
        final ClassDescription.TypeParameterList typeparams;
        String sig;
        int siglength;
        char chr;
        int idx;

        SignatureParser(String name, ClassDescription.TypeParameterList pars) {
            this.ownname = name;
            this.typeparams = pars;
        }

        void scanClass(String s) {
            this.sig = s + "\n";
            this.siglength = this.sig.length();
            this.idx = 0;
            this.chr = this.sig.charAt(this.idx++);
            this.generic_pars = this.scanFormalTypeParameters(this.ownname);
            this.class_supr = this.scanFieldTypeSignature(true);
            this.class_intfs = new ArrayList<String>();
            while (!this.eol()) {
                String intf = this.scanFieldTypeSignature(true);
                this.class_intfs.add(intf);
            }
        }

        void scanField(String s) {
            this.sig = s + "\n";
            this.siglength = this.sig.length();
            this.idx = 0;
            this.chr = this.sig.charAt(this.idx++);
            this.field_type = this.scanFieldTypeSignature(true);
        }

        void scanMethod(String s) {
            String t;
            this.sig = s + "\n";
            this.siglength = this.sig.length();
            this.idx = 0;
            this.chr = this.sig.charAt(this.idx++);
            this.generic_pars = this.scanFormalTypeParameters("%");
            this.method_args = new ArrayList<String>();
            this.scanChar('(');
            while (this.chr != ')') {
                t = this.scanFieldTypeSignature(true);
                this.method_args.add(t);
            }
            this.scanChar(')');
            this.field_type = this.scanFieldTypeSignature(true);
            this.method_throws = new ArrayList<String>();
            while (this.chr == '^') {
                this.scanChar();
                t = this.scanFieldTypeSignature(true);
                this.method_throws.add(t);
            }
            this.typeparams.clear("%");
        }

        String scanFormalTypeParameters(String declared) {
            if (this.chr != '<') {
                return null;
            }
            ArrayList parameters = new ArrayList();
            this.typeparams.reset_count();
            this.scanChar('<');
            do {
                String ident = this.scanIdent(":>");
                ArrayList<String> bounds = new ArrayList<String>();
                while (this.chr == ':') {
                    this.scanChar();
                    String bound = null;
                    if (this.chr != ':') {
                        bound = this.scanFieldTypeSignature(false);
                    }
                    if (bound == null) continue;
                    bounds.add(bound);
                }
                parameters.add(bounds);
                this.typeparams.add(ident, declared);
            } while (this.chr != '>');
            this.scanChar('>');
            StringBuffer sb = new StringBuffer();
            sb.append('<');
            for (int i = 0; i < parameters.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append('%').append(i);
                List bounds = (List)parameters.get(i);
                for (int k = 0; k < bounds.size(); ++k) {
                    bounds.set(k, this.typeparams.replaceForwards((String)bounds.get(k)));
                }
                if (bounds.isEmpty()) continue;
                String first = (String)bounds.remove(0);
                sb.append(" extends ").append(first);
                if (bounds.isEmpty()) continue;
                Collections.sort(bounds);
                for (String bound : bounds) {
                    sb.append(" & ").append(bound);
                }
            }
            sb.append('>');
            return sb.toString();
        }

        String scanFieldTypeSignature(boolean repl) {
            switch (this.chr) {
                case '[': {
                    this.scanChar();
                    return this.scanFieldTypeSignature(repl) + "[]";
                }
                case 'L': {
                    this.scanChar();
                    StringBuffer sb = new StringBuffer();
                    StringBuffer sb1 = new StringBuffer();
                    while (true) {
                        sb.append(this.scanIdent("<.;").replace('/', '.'));
                        if (this.chr == '<') {
                            this.scanChar();
                            sb1.append('<');
                            sb1.append(this.scanTypeArgument(repl));
                            while (this.chr != '>') {
                                sb1.append(',').append(this.scanTypeArgument(repl));
                            }
                            this.scanChar('>');
                            sb1.append('>');
                        }
                        if (this.chr != '.') {
                            if (sb1.length() == 0) break;
                            sb.append(sb1);
                            break;
                        }
                        sb1.setLength(0);
                        this.scanChar();
                        sb.append('$');
                    }
                    this.scanChar(';');
                    return sb.toString();
                }
                case 'T': {
                    this.scanChar();
                    String ident = this.scanIdent(";");
                    this.scanChar(';');
                    return repl ? this.typeparams.replace(ident) : ClassDescription.TypeParameterList.replaceNone(ident);
                }
            }
            String t = PrimitiveTypes.getPrimitiveType(this.chr);
            if (t != null) {
                this.scanChar();
                return t;
            }
            this.err("?TypeChar " + this.chr);
            return null;
        }

        String scanTypeArgument(boolean repl) {
            String object = "java.lang.Object";
            switch (this.chr) {
                case '*': {
                    this.scanChar();
                    return "?";
                }
                case '+': {
                    this.scanChar();
                    String s = this.scanFieldTypeSignature(repl);
                    if (s.startsWith("java.lang.Object")) {
                        s = s.substring("java.lang.Object".length()).trim();
                    }
                    return !s.isEmpty() ? "? extends " + s : "?";
                }
                case '-': {
                    this.scanChar();
                    return "? super " + this.scanFieldTypeSignature(repl);
                }
            }
            return this.scanFieldTypeSignature(repl);
        }

        String scanIdent(String term) {
            StringBuffer sb = new StringBuffer();
            while (term.indexOf(this.chr) == -1) {
                sb.append(this.chr);
                this.scanChar();
            }
            if (sb.length() == 0) {
                this.err(null);
            }
            return sb.toString();
        }

        char scanChar(char c) {
            if (this.chr != c) {
                this.err(null);
            }
            return this.scanChar();
        }

        char scanChar() {
            if (this.idx >= this.siglength) {
                this.err(null);
            }
            this.chr = this.sig.charAt(this.idx++);
            return this.chr;
        }

        boolean eol() {
            return this.idx >= this.siglength;
        }

        void err(String msg) throws Error {
            throw new SigAttrError(this.showerr() + (msg == null ? "" : "\n" + msg));
        }

        String showerr() {
            Object[] args = new String[]{this.sig.substring(0, this.siglength - 1), this.ownname};
            return i18n.getString("BinaryClassDescrLoader.error.attribute", args);
        }
    }

    private abstract class AttrsIter {
        DataInputStream is;
        boolean synthetic = false;
        boolean deprecated = false;
        String signature = null;
        List<AnnotationItem> annolist = null;
        Object annodef = null;

        private AttrsIter() {
        }

        void read(BinaryClassDescription c, DataInput classData) throws IOException {
            int n = classData.readUnsignedShort();
            for (int i = 0; i < n; ++i) {
                String name = c.getName(classData.readUnsignedShort());
                int count = classData.readInt();
                if (count != 0) {
                    byte[] info = new byte[count];
                    classData.readFully(info);
                    this.is = new DataInputStream(new ByteArrayInputStream(info));
                }
                if (name.equals("Synthetic")) {
                    this.synthetic = true;
                } else if (name.equals("Deprecated")) {
                    this.deprecated = true;
                } else if (name.equals("Signature")) {
                    this.checkVersion(c, name, 49);
                    this.signature = c.getName(this.is.readUnsignedShort());
                } else if (SigTest.isTigerFeaturesTracked && name.equals("RuntimeVisibleAnnotations")) {
                    this.checkVersion(c, name, 49);
                    this.readAnnotations(c, 0);
                } else if (SigTest.isTigerFeaturesTracked && name.equals("RuntimeInvisibleAnnotations")) {
                    this.checkVersion(c, name, 49);
                    this.readAnnotations(c, 0);
                } else if (SigTest.isTigerFeaturesTracked && name.equals("RuntimeVisibleTypeAnnotations")) {
                    this.checkVersion(c, name, 51);
                    this.readExtAnnotations(c, 0);
                } else if (SigTest.isTigerFeaturesTracked && name.equals("RuntimeInvisibleTypeAnnotations")) {
                    this.checkVersion(c, name, 51);
                    this.readExtAnnotations(c, 0);
                } else if (SigTest.isTigerFeaturesTracked && (name.equals("RuntimeVisibleParameterAnnotations") || name.equals("RuntimeInvisibleParameterAnnotations"))) {
                    this.checkVersion(c, name, 49);
                    int m = this.is.readUnsignedByte();
                    for (int l = 0; l < m; ++l) {
                        this.readAnnotations(c, l + 1);
                    }
                } else if (SigTest.isTigerFeaturesTracked && name.equals("AnnotationDefault")) {
                    this.checkVersion(c, name, 49);
                    this.annodef = this.read_member_value(c);
                } else {
                    this.check(c, name);
                }
                if (count == 0) continue;
                try {
                    this.is.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        void readAnnotations(BinaryClassDescription c, int target) throws IOException {
            if (BinaryClassDescrLoader.this.ignoreAnnotations) {
                return;
            }
            if (this.annolist == null) {
                this.annolist = new ArrayList<AnnotationItem>();
            }
            int m = this.is.readUnsignedShort();
            for (int l = 0; l < m; ++l) {
                AnnotationItem anno = this.readAnnotation(c, target, false);
                this.annolist.add(anno);
            }
        }

        void readExtAnnotations(BinaryClassDescription c, int target) throws IOException {
            if (BinaryClassDescrLoader.this.ignoreAnnotations) {
                return;
            }
            if (this.annolist == null) {
                this.annolist = new ArrayList<AnnotationItem>();
            }
            int m = this.readShort();
            for (int l = 0; l < m; ++l) {
                AnnotationItemEx anno = (AnnotationItemEx)this.readAnnotation(c, target, true);
                if (!anno.getTracked() && !BinaryClassDescrLoader.this.hasHint(LoadingHints.READ_ANY_ANNOTATIONS)) continue;
                this.annolist.add(anno);
            }
        }

        private int readByte() throws IOException {
            return this.is.readUnsignedByte();
        }

        private int readChar() throws IOException {
            return this.is.readChar();
        }

        private int readShort() throws IOException {
            return this.is.readUnsignedShort();
        }

        private int[] readLocations() throws IOException {
            int location_length = this.is.readUnsignedShort();
            int[] loc = new int[location_length];
            for (int i = 0; i < location_length; ++i) {
                loc[i] = this.is.readUnsignedByte();
            }
            return loc;
        }

        private AnnotationItem readAnnotation(BinaryClassDescription c, int target, boolean isExtended) throws IOException {
            AnnotationItem anno;
            if (isExtended) {
                AnnotationItemEx annox = new AnnotationItemEx(target);
                annox.parseBinaryDescription(this.is);
                anno = annox;
            } else {
                anno = new AnnotationItem(target);
            }
            String name = c.getName(this.readShort());
            name = BinaryClassDescrLoader.getArgs(name);
            anno.setName(name);
            int k = this.is.readUnsignedShort();
            for (int j = 0; j < k; ++j) {
                anno.addMember(new AnnotationItem.Member(c.getName(this.is.readUnsignedShort()), this.read_member_value(c)));
            }
            this.completeAnnotation(anno);
            return anno;
        }

        void completeAnnotation(AnnotationItem anno) {
            block9: {
                try {
                    AnnotationItem[] annoList;
                    ClassDescription c;
                    try {
                        c = BinaryClassDescrLoader.this.load(anno.getName());
                    }
                    catch (ClassNotFoundException ex) {
                        c = BinaryClassDescrLoader.this.altLoad(anno.getName());
                    }
                    for (AnnotationItem annotationItem : annoList = c.getAnnoList()) {
                        if (!"java.lang.annotation.Inherited".equals(annotationItem.getName())) continue;
                        anno.setInheritable(true);
                    }
                    MethodDescr[] fids = c.getDeclaredMethods();
                    if (fids != null) {
                        for (MethodDescr fid : fids) {
                            AnnotationItem.Member member = anno.findByName(fid.getName());
                            if (member != null) {
                                anno.removeMember(member);
                                member.setType(fid.getType());
                            } else {
                                member = new AnnotationItem.Member(fid.getType(), fid.getName(), fid.getAnnoDef());
                            }
                            anno.addMember(member);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (BinaryClassDescrLoader.this.notFoundAnnotations.contains(anno.getName())) break block9;
                    BinaryClassDescrLoader.this.getLog().println("Warning: " + i18n.getString("BinaryClassDescrLoader.error.annotnotfound", anno.getName()));
                    BinaryClassDescrLoader.this.notFoundAnnotations.add(anno.getName());
                }
            }
        }

        Object read_member_value(BinaryClassDescription c) throws IOException {
            Object v;
            byte tag = this.is.readByte();
            switch (tag) {
                case 90: {
                    v = c.getConstantValue(this.is.readUnsignedShort());
                    v = (Integer)v != 0;
                    break;
                }
                case 66: {
                    v = c.getConstantValue(this.is.readUnsignedShort());
                    v = ((Integer)v).byteValue();
                    break;
                }
                case 67: {
                    v = c.getConstantValue(this.is.readUnsignedShort());
                    v = Character.valueOf((char)((Integer)v).shortValue());
                    break;
                }
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 115: {
                    v = c.getConstantValue(this.is.readUnsignedShort());
                    break;
                }
                case 101: {
                    this.is.readUnsignedShort();
                    v = new AnnotationItem.ValueWrap(c.getName(this.is.readUnsignedShort()));
                    break;
                }
                case 99: {
                    String s = BinaryClassDescrLoader.convertVMType(c.getName(this.is.readUnsignedShort()));
                    v = new AnnotationItem.ValueWrap("class " + s);
                    break;
                }
                case 64: {
                    v = this.readAnnotation(c, 0, false);
                    break;
                }
                case 91: {
                    int n = this.is.readUnsignedShort();
                    Object[] tmp = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        tmp[i] = this.read_member_value(c);
                    }
                    v = tmp;
                    break;
                }
                default: {
                    throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.unknownannot", Integer.toString(tag)));
                }
            }
            return v;
        }

        void checkVersion(BinaryClassDescription c, String name, int vnbr) {
            Object[] args = new String[]{name, c.getQualifiedName(), Integer.toString(c.major_version), Integer.toString(c.minor_version)};
            if (c.major_version < vnbr) {
                BinaryClassDescrLoader.this.getLog().println(i18n.getString("BinaryClassDescrLoader.message.attribute", args));
            }
        }

        abstract void check(BinaryClassDescription var1, String var2) throws IOException;
    }

    class MethodAttrs
    extends AttrsIter {
        String[] xthrows;

        MethodAttrs() {
        }

        @Override
        void check(BinaryClassDescription c, String s) throws IOException {
            if (s.equals("Exceptions")) {
                int n = this.is.readUnsignedShort();
                this.xthrows = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.xthrows[i] = c.getClassName(this.is.readUnsignedShort());
                }
            }
        }
    }

    class FieldAttrs
    extends AttrsIter {
        Object value = null;

        FieldAttrs() {
        }

        @Override
        void check(BinaryClassDescription c, String s) throws IOException {
            if (s.equals("ConstantValue")) {
                if (this.value != null) {
                    BinaryClassDescrLoader.this.err(null);
                }
                this.value = c.getConstantValue(this.is.readUnsignedShort());
            }
        }
    }

    private class ClassAttrs
    extends AttrsIter {
        int access = -1;

        private ClassAttrs() {
        }

        @Override
        void check(BinaryClassDescription c, String s) throws IOException {
            if (s.equals("InnerClasses")) {
                ArrayList<InnerDescr> tmp = null;
                String fqname = c.getQualifiedName();
                int n = this.is.readUnsignedShort();
                for (int i = 0; i < n; ++i) {
                    String inner = c.getClassName(this.is.readUnsignedShort());
                    String outer = c.getClassName(this.is.readUnsignedShort());
                    this.is.readUnsignedShort();
                    int x = this.is.readUnsignedShort();
                    if (inner != null && inner.equals(fqname)) {
                        if (this.access != -1) {
                            BinaryClassDescrLoader.this.err(null);
                        }
                        this.access = x;
                        c.setModifiers(x);
                        c.setupClassName(fqname, outer);
                    }
                    if (!BinaryClassDescrLoader.this.hasHint(LoadingHints.READ_SYNTETHIC) && Modifier.hasModifier(x, Modifier.ACC_SYNTHETIC) || outer == null || !outer.equals(fqname) || inner == null || inner.indexOf(outer) != 0) continue;
                    if (tmp == null) {
                        tmp = new ArrayList<InnerDescr>();
                    }
                    tmp.add(new InnerDescr(inner, outer, x));
                }
                if (tmp != null) {
                    c.setNestedClasses(tmp.toArray(InnerDescr.EMPTY_ARRAY));
                }
            }
        }
    }

    private static class Constant {
        byte tag;
        Object info;

        private Constant() {
        }

        void checkConstant(int exp) {
            if (this.tag != exp) {
                Object[] consts = new String[]{Integer.toString(exp & 0xFF), Integer.toString(this.tag & 0xFF)};
                throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.const", consts));
            }
        }

        String getName() {
            this.checkConstant(1);
            return (String)this.info;
        }

        void read(DataInput classData) throws IOException {
            this.tag = classData.readByte();
            switch (this.tag) {
                case 7: {
                    this.info = classData.readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.info = classData.readInt();
                    break;
                }
                case 8: {
                    this.info = classData.readShort();
                    break;
                }
                case 3: {
                    this.info = classData.readInt();
                    break;
                }
                case 4: {
                    this.info = Float.valueOf(classData.readFloat());
                    break;
                }
                case 5: {
                    this.info = classData.readLong();
                    break;
                }
                case 6: {
                    this.info = classData.readDouble();
                    break;
                }
                case 12: {
                    this.info = classData.readInt();
                    break;
                }
                case 1: {
                    this.info = classData.readUTF();
                    break;
                }
                case 15: {
                    classData.readUnsignedByte();
                    classData.readUnsignedShort();
                    this.info = "CONSTANT_MethodHandle";
                    break;
                }
                case 16: {
                    classData.readUnsignedShort();
                    this.info = "CONSTANT_MethodType";
                    break;
                }
                case 17: {
                    classData.readUnsignedShort();
                    classData.readUnsignedShort();
                    this.info = "CONSTANT_Dynamic";
                    break;
                }
                case 18: {
                    classData.readUnsignedShort();
                    classData.readUnsignedShort();
                    this.info = "CONSTANT_InvokeDynamic";
                    break;
                }
                case 19: 
                case 20: {
                    classData.readUnsignedShort();
                    classData.readUnsignedShort();
                    this.info = "CONSTANT_ModuleId";
                    break;
                }
                default: {
                    throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.unknownconst", Integer.toString(this.tag)));
                }
            }
        }
    }

    private class BinaryClassDescription
    extends ClassDescription {
        private int major_version;
        private int minor_version;
        private Constant[] constants;
        private String[] sigctors;
        private String[] sigfields;
        private String[] sigmethods;

        private BinaryClassDescription() {
        }

        private void readCP(DataInput classData) throws IOException {
            int n = classData.readUnsignedShort();
            this.constants = new Constant[n];
            this.constants[0] = null;
            for (int i = 1; i < n; ++i) {
                this.constants[i] = new Constant();
                this.constants[i].read(classData);
                if (this.constants[i].tag != 5 && this.constants[i].tag != 6) continue;
                ++i;
            }
        }

        List<MemberDescription> getMethodRefs() {
            ArrayList<MemberDescription> memberList = new ArrayList<MemberDescription>();
            int n = this.constants.length;
            for (int i = 1; i < n; ++i) {
                MemberDescription fid;
                if (this.constants[i].tag == 5 || this.constants[i].tag == 6) {
                    ++i;
                    continue;
                }
                if (this.constants[i].tag != 10 && this.constants[i].tag != 11 && this.constants[i].tag != 9) continue;
                int refs = (Integer)this.getConstant((int)i).info;
                short nameAndType = (short)refs;
                short decl = (short)(refs >> 16);
                String methodName = this.getMethodName(nameAndType);
                String className = this.getClassName(decl);
                boolean isConstructor = "<init>".equals(methodName);
                if (this.constants[i].tag == 9) {
                    fid = new FieldDescr(methodName, className, 1);
                } else {
                    if (isConstructor) {
                        fid = new ConstructorDescr(this, 1);
                        fid.setDeclaringClass(className);
                    } else {
                        fid = new MethodDescr(methodName, className, 1);
                    }
                    String descr = this.getMethodType(nameAndType);
                    int pos = descr.indexOf(41);
                    try {
                        fid.setArgs(BinaryClassDescrLoader.getArgs(descr.substring(1, pos)));
                    }
                    catch (IllegalArgumentException e) {
                        BinaryClassDescrLoader.this.err(i18n.getString("BinaryClassDescrLoader.message.incorrectformat", Short.toString(decl)));
                    }
                }
                memberList.add(fid);
            }
            return memberList;
        }

        private Constant getConstant(int i) {
            if (i <= 0 || i >= this.constants.length) {
                throw new ClassFormatError(i18n.getString("BinaryClassDescrLoader.error.cpoutofbounds"));
            }
            return this.constants[i];
        }

        String getClassName(int i) {
            if (i == 0) {
                return null;
            }
            Constant c = this.getConstant(i);
            c.checkConstant(7);
            c = this.getConstant((Integer)c.info);
            c.checkConstant(1);
            return ((String)c.info).replace('/', '.');
        }

        private String getMethodName(int i) {
            if (i == 0) {
                return null;
            }
            Constant c = this.getConstant(i);
            c.checkConstant(12);
            return this.getName((Integer)c.info >> 16);
        }

        private String getMethodType(int i) {
            if (i == 0) {
                return null;
            }
            Constant c = this.getConstant(i);
            c.checkConstant(12);
            return this.getName(((Integer)c.info).shortValue());
        }

        private Object getConstantValue(int i) {
            Constant c = this.getConstant(i);
            if (c.tag == 8) {
                return this.getName(((Short)c.info).intValue() & 0xFFFF);
            }
            return c.info;
        }

        private String getName(int i) {
            Constant c = this.getConstant(i);
            c.checkConstant(1);
            return (String)c.info;
        }

        private void cleanup() {
            this.sigctors = null;
            this.sigfields = null;
            this.sigmethods = null;
            this.constants = null;
        }

        static /* synthetic */ String[] access$1302(BinaryClassDescription x0, String[] x1) {
            x0.sigfields = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1502(BinaryClassDescription x0, String[] x1) {
            x0.sigctors = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1602(BinaryClassDescription x0, String[] x1) {
            x0.sigmethods = x1;
            return x1;
        }
    }
}

