/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.base64binary.length.length_2;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class length2_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        length2_ValidateCTTests test = new length2_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final String[] validValues = {"AAA=", "cmM=", "Ynk=", "cXM=", "a3c=", "c20="};
    
    final String[] invalidValues = {"", "1234", "1w==", "AAAAcXM="};
    
    JAXBElement<byte[]> elemObj;

    static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    static byte [] getBytes(String base64) {
        if (base64.length()%4 != 0) {
            throw new TestFailureException("test error: wrong length of base64 encoded data:" + base64);
        }
        int nOctets = base64.length() / 4 * 3;
        if (base64.endsWith("==")) {
            nOctets -= 2;
        } else if (base64.endsWith("=")) {
            nOctets -= 1;
        }
        byte [] bytes = new byte[nOctets];
        for (int i = (base64.length() / 4) - 1; i >= 0; --i) {
            int threeBytes = ((base64Chars.indexOf(base64.charAt(i*4)) & 0x3f) << 18)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 1)) & 0x3f) << 12)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 2)) & 0x3f) << 6)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 3)) & 0x3f));
            bytes[i*3] = (byte)((threeBytes >> 16) & 0xff);
            if (base64.charAt(i*4 + 2) != '=') {
                bytes[i*3 + 1] = (byte)((threeBytes >> 8) & 0xff);
                if (base64.charAt(i*4 + 3) != '=') {
                    bytes[i*3 + 2] = (byte)((threeBytes) & 0xff);
                }
            }
        }
        return bytes;
    }

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(getBytes(invalidValues[i]));
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(getBytes(validValues[i]));
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<byte[]>)unmarshal("length-2-4.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<byte[]>)unmarshal("length-2-4.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<byte[]>)(new ObjectFactory()).createNISTSchemaBase64BinaryLength2(getBytes(validValues[0]));
        
        return testValid();
    }

    public Status Created002( ) {
        elemObj = (JAXBElement<byte[]>)(new ObjectFactory()).createNISTSchemaBase64BinaryLength2(getBytes(validValues[0]));
        
        return testInvalid();
    }


}

