/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.positiveinteger.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_GetSetCTTests test = new enumeration1_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "enumeration-1-1.xml", "enumeration-1-2.xml", "enumeration-1-3.xml",
            "enumeration-1-4.xml", "enumeration-1-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("9936"), new BigInteger("4305434507488021"), new BigInteger("43876110718277"),
                                       new BigInteger("43876110718277"), new BigInteger("5547")};
        BigInteger[] anExpectedValues = {new BigInteger("550215893734272"), new BigInteger("5547"), new BigInteger("43876110718277"),
                                         new BigInteger("865014204294391"), new BigInteger("43876110718277")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("9936"), new BigInteger("4305434507488021"), new BigInteger("43876110718277"),
                                       new BigInteger("43876110718277"), new BigInteger("5547")};
        BigInteger[] anSetValues = {new BigInteger("550215893734272"), new BigInteger("5547"), new BigInteger("43876110718277"),
                                         new BigInteger("865014204294391"), new BigInteger("43876110718277")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaPositiveIntegerEnumeration1(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

