/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.exclude;

import com.sun.tdk.signaturetest.core.Exclude;
import com.sun.tdk.signaturetest.core.ExcludeException;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExcludeList
implements Exclude {
    private List excludeList = new ArrayList();

    public void addSignature(String name) {
        String regpack1 = name.replaceAll("(\\.|\\(|\\)|\\{|\\}|\\[|\\]|\\%|\\$)", "\\\\$1");
        String regpack = regpack1.replaceAll("\\\\\\\\", "");
        try {
            this.excludeList.add(Pattern.compile(regpack));
        }
        catch (PatternSyntaxException e) {
            System.err.println("Error in -ExcludeSig: " + e.getMessage());
        }
    }

    @Override
    public void check(ClassDescription testedClass, MemberDescription name) throws ExcludeException {
        String signature = name.getQualifiedName().replaceAll("<[^<>]+>", "");
        if (name.isMethod() || name.isConstructor()) {
            signature = signature + '(';
            signature = signature + name.getArgs().replaceAll("<[^<>]+>", "");
            signature = signature + ')';
        }
        for (Pattern p : this.excludeList) {
            Matcher m = p.matcher(signature);
            if (!m.matches()) continue;
            throw new ExcludeException(p.pattern());
        }
    }

    @Override
    public String[] parseParameters(String[] args) {
        HashSet<String> rest = new HashSet<String>();
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            String parameter = (String)i.next();
            if (!parameter.equalsIgnoreCase("-excludesig")) continue;
            rest.add(parameter);
            parameter = (String)i.next();
            this.addSignature(parameter);
            rest.add(parameter);
        }
        parameters.removeAll(rest);
        return parameters.toArray(new String[0]);
    }

    @Override
    public String report() {
        return "finished";
    }
}

