/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * $Id: AddressingEndpointImpl.java 52501 2007-01-24 02:29:49Z lschwenk $
 */

package com.sun.ts.tests.jaxws.mapping.j2wmapping.rpc.literal.withannotations;

import jakarta.xml.ws.WebServiceException;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.soap.SOAPBinding;
import jakarta.xml.ws.soap.Addressing;

@WebService(portName = "AddressingEndpointPort", serviceName = "AddressingService", targetNamespace = "http://rpclitservice.org/wsdl", endpointInterface = "com.sun.ts.tests.jaxws.mapping.j2wmapping.rpc.literal.withannotations.AddressingEndpoint")
@BindingType(value = SOAPBinding.SOAP11HTTP_BINDING)
@Addressing(enabled = true, required = true)
public class AddressingEndpointImpl implements AddressingEndpoint {

  public void address1(String s) {
  }

  public String address2() {
    return "hello";
  }

  public String address3(String s) throws MyFault1 {
    throw new MyFault1("MyFault1");
  }

  public String address4() throws MyFault1 {
    throw new MyFault1("MyFault1");
  }

  public String address5(String s) throws MyFault1 {
    throw new MyFault1("MyFault1");
  }

  public void address6(String s) throws MyFault1 {
  }

  public String address7() throws MyFault1 {
    return "hello";
  }
}
