/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AppendAfter
extends Task {
    private String srcFile = null;
    private String destFile = null;
    private String searchString = null;
    private String appendString = null;
    private String occurrence = "all";
    private String index = "0";

    public void setSrcFile(String s) {
        this.srcFile = s;
    }

    public void setDestFile(String s) {
        this.destFile = s;
    }

    public void setSearchString(String s) {
        this.searchString = s;
    }

    public void setAppendString(String s) {
        this.appendString = s;
    }

    public void setOccurrence(String s) {
        this.occurrence = s;
    }

    public void setIndex(String s) {
        this.index = s;
    }

    public void execute() throws BuildException {
        BufferedReader in = null;
        PrintWriter out = null;
        if (this.srcFile == null) {
            throw new BuildException("The src attribute must be set.");
        }
        if (this.destFile == null) {
            throw new BuildException("The dest attribute must be set.");
        }
        if (this.srcFile.equals(this.destFile)) {
            throw new BuildException("file " + this.srcFile + " would overwrite its self");
        }
        if (this.searchString == null) {
            throw new BuildException("a searchString must be specified");
        }
        if (this.appendString == null) {
            throw new BuildException("a appendString must be specified");
        }
        if (this.occurrence.equals("specific") || this.occurrence.equals("after")) {
            if (this.index.equals("0")) {
                throw new BuildException("an index must be specified if an occurrence other than all is specified");
            }
        } else if (!this.occurrence.equals("all")) {
            throw new BuildException("must specify all, specific, or after for the occurrence attribute");
        }
        try {
            in = new BufferedReader(new FileReader(this.srcFile));
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.destFile)));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        String text = "";
        int count = 0;
        while (text != null) {
            try {
                text = in.readLine();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
            if (text == null) continue;
            out.println(text);
            if (text.indexOf(this.searchString) == -1 || !this.occurrence.equals("all") && (!this.occurrence.equals("specific") || ++count != Integer.parseInt(this.index)) && (!this.occurrence.equals("after") || count < Integer.parseInt(this.index))) continue;
            out.println(this.appendString);
        }
        try {
            in.close();
            out.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

