/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Erasurator {
    private final Map<String, String> globalParameters = new HashMap<String, String>();
    private final Map<String, String> localParameters = new HashMap<String, String>();
    private final Set<String> unresolvedWarnings = new HashSet<String>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Erasurator.class);
    private final BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
    private static final Pattern simpleParamName = Pattern.compile("^%\\d+?");
    private static final Pattern simpleParamUsage = Pattern.compile("<[^<>]+?>");
    private static final Pattern replaceParamUsage = Pattern.compile("\\{.+?\\}");

    public ClassDescription erasure(ClassDescription clz) {
        ClassDescription result = (ClassDescription)clz.clone();
        this.globalParameters.clear();
        if (result.getTypeParameters() != null) {
            this.parseTypeParameters(result);
            result.setTypeParameters(null);
        }
        this.processMembers(result);
        return result;
    }

    public ClassDescription fullErasure(ClassDescription clz) {
        ClassDescription result = (ClassDescription)clz.clone();
        this.globalParameters.clear();
        if (result.getTypeParameters() != null) {
            this.parseTypeParameters(result);
            result.setTypeParameters(null);
        }
        this.processDeclaredMembers(result);
        return result;
    }

    private String convert(String s, Map<String, String> globalParameters, Map<String, String> localParameters) {
        Matcher m;
        String newS = s;
        while (newS.indexOf(60) != -1) {
            assert (newS.indexOf(62) != -1);
            m = simpleParamUsage.matcher(newS);
            newS = m.replaceAll("");
        }
        if (globalParameters.isEmpty() && localParameters.isEmpty()) {
            return newS;
        }
        m = replaceParamUsage.matcher(newS);
        while (m.find()) {
            String param = m.group();
            if (globalParameters.containsKey(param)) {
                newS = m.replaceFirst(globalParameters.get(param));
                m = replaceParamUsage.matcher(newS);
                continue;
            }
            if (localParameters.containsKey(param)) {
                newS = m.replaceFirst(localParameters.get(param));
                m = replaceParamUsage.matcher(newS);
                continue;
            }
            if (this.unresolvedWarnings.contains(param)) continue;
            System.out.println(i18n.getString("Erasurator.error.unresolved", param));
            this.unresolvedWarnings.add(param);
        }
        return newS;
    }

    public void parseTypeParameters(ClassDescription classDescr) {
        if (classDescr.getTypeParameters() != null) {
            Erasurator.parseTypeParameters(classDescr, this.globalParameters);
        }
    }

    private static void parseTypeParameters(MemberDescription member, Map<String, String> parameters) {
        StringTokenizer st = new StringTokenizer(member.getTypeParameters(), "<>,");
        String ext = " extends ";
        boolean isClass = member.isClass();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            Matcher m = simpleParamName.matcher(token);
            if (!m.lookingAt()) continue;
            String name = token.substring(m.start(), m.end());
            String key = isClass ? "{" + member.getQualifiedName() + name + "}" : "{%" + name + "}";
            if (token.length() <= m.end() || !token.substring(m.end()).startsWith(" extends ")) continue;
            String val = token.substring(m.end() + " extends ".length()).trim();
            if (val.indexOf(32) >= 0) {
                val = val.substring(0, val.indexOf(32));
            }
            parameters.put(key, Erasurator.maskDollar(val));
        }
    }

    private void processDeclaredMembers(ClassDescription clz) {
        ConstructorDescr[] constrs = clz.getDeclaredConstructors();
        clz.setConstructors(new ConstructorDescr[constrs.length]);
        for (int i = 0; i < constrs.length; ++i) {
            clz.setConstructor(i, (ConstructorDescr)this.processMember(constrs[i], false));
        }
        MethodDescr[] meths = clz.getDeclaredMethods();
        clz.setMethods(new MethodDescr[meths.length]);
        for (int i = 0; i < meths.length; ++i) {
            clz.setMethod(i, (MethodDescr)this.processMember(meths[i], false));
        }
        FieldDescr[] flds = clz.getDeclaredFields();
        clz.setFields(new FieldDescr[flds.length]);
        for (int i = 0; i < flds.length; ++i) {
            clz.setField(i, (FieldDescr)this.processMember(flds[i], false));
        }
        InnerDescr[] inners = clz.getDeclaredClasses();
        clz.setNestedClasses(new InnerDescr[inners.length]);
        for (int i = 0; i < inners.length; ++i) {
            clz.setNested(i, (InnerDescr)this.processMember(inners[i], false));
        }
    }

    private void processMembers(ClassDescription clz) {
        MemberCollection newMembers = new MemberCollection();
        Iterator<MemberDescription> e = clz.getMembersIterator();
        while (e.hasNext()) {
            newMembers.addMember(this.processMember(e.next()));
        }
        clz.setMembers(newMembers);
    }

    public MemberDescription processMember(MemberDescription mr) {
        return this.processMember(mr, false);
    }

    private MemberDescription processMember(MemberDescription mr, boolean dontClone) {
        String s;
        int fl;
        String ths;
        String type;
        assert (!mr.isClass());
        this.localParameters.clear();
        if (mr.getTypeParameters() != null) {
            Erasurator.parseTypeParameters(mr, this.localParameters);
        }
        MemberDescription cloned_m = mr;
        if (!dontClone) {
            cloned_m = (MemberDescription)mr.clone();
        }
        cloned_m.setTypeParameters(null);
        String args = cloned_m.getArgs();
        if (!"".equals(args)) {
            cloned_m.setArgs(this.convert(args, this.globalParameters, this.localParameters));
        }
        if (!"".equals(type = cloned_m.getType())) {
            cloned_m.setType(this.convert(type, this.globalParameters, this.localParameters));
        }
        if (!"".equals(ths = cloned_m.getThrowables())) {
            cloned_m.setThrowables(this.convert(ths, this.globalParameters, this.localParameters));
        }
        if (this.bo.isSet(Option.DEBUG) && (fl = (s = cloned_m.toString()).indexOf(10)) > 0) {
            s = s.substring(0, fl);
        }
        return cloned_m;
    }

    public static List<String> splitParameters(String actualTypeParams) {
        ArrayList<String> paramList = new ArrayList<String>();
        int startPos = 1;
        int level = 0;
        int len = actualTypeParams.length() - 1;
        block5: for (int i = 1; i < len; ++i) {
            switch (actualTypeParams.charAt(i)) {
                case '<': {
                    ++level;
                    continue block5;
                }
                case '>': {
                    --level;
                    continue block5;
                }
                case ',': {
                    if (level != 0) continue block5;
                    paramList.add(actualTypeParams.substring(startPos, i));
                    startPos = i + 1;
                }
            }
        }
        paramList.add(actualTypeParams.substring(startPos, len));
        return paramList;
    }

    public static MemberDescription[] replaceFormalParameters(String fqn, MemberDescription[] members, List<String> actualTypeParamList, boolean skipRawTypes) {
        MemberDescription[] result = new MemberDescription[members.length];
        for (int i = 0; i < members.length; ++i) {
            result[i] = Erasurator.replaceFormalParameters(fqn, members[i], actualTypeParamList, skipRawTypes);
        }
        return result;
    }

    public static Collection<MemberDescription> replaceFormalParameters(String fqn, Collection<MemberDescription> members, List<String> actualTypeParamList, boolean skipRawTypes) {
        assert (!actualTypeParamList.isEmpty());
        ArrayList<MemberDescription> result = new ArrayList<MemberDescription>();
        for (MemberDescription member : members) {
            MemberDescription newFid = Erasurator.replaceFormalParameters(fqn, member, actualTypeParamList, skipRawTypes);
            result.add(newFid);
        }
        return result;
    }

    private static MemberDescription replaceFormalParameters(String fqn, MemberDescription fid, List<String> actualTypeParamList, boolean skipRawTypes) {
        MemberDescription newFid = (MemberDescription)fid.clone();
        for (int i = 0; i < actualTypeParamList.size(); ++i) {
            String actual = actualTypeParamList.get(i);
            if (skipRawTypes && actual.indexOf(37) == -1) continue;
            String key = "\\{" + fqn + "%" + i + "\\}";
            Erasurator.replaceFormalParameters(newFid, key, actual);
        }
        return newFid;
    }

    private static void replaceFormalParameters(MemberDescription mr, String formalParam, String actualParam) {
        String typeParams;
        String type;
        Matcher m;
        String actual = Erasurator.maskDollar(actualParam);
        Pattern p = Pattern.compile(Erasurator.maskDollar(formalParam));
        String args = mr.getArgs();
        if (!"".equals(args)) {
            m = p.matcher(args);
            mr.setArgs(m.replaceAll(actual));
        }
        if (!"".equals(type = mr.getType())) {
            m = p.matcher(type);
            mr.setType(m.replaceAll(actual));
        }
        if ((mr.isSuperInterface() || mr.isSuperClass()) && (typeParams = mr.getTypeParameters()) != null) {
            m = p.matcher(typeParams);
            mr.setTypeParameters(m.replaceAll(actual));
        }
    }

    private static String maskDollar(String str) {
        int pos;
        String tmp = str;
        StringBuilder result = new StringBuilder();
        do {
            if ((pos = tmp.indexOf(36)) == -1) continue;
            result.append(tmp, 0, pos);
            result.append("\\$");
            tmp = tmp.substring(pos + 1);
        } while (pos != -1);
        result.append(tmp);
        return result.toString();
    }
}

