/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;

public class MessageType
implements Comparable<MessageType> {
    private final String text;
    private final int id;
    private final boolean thisIsWarning;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MessageType.class);
    public static final MessageType ERROR_UNKNOWN = new MessageType(i18n.getString("ErrorFormatter.error.unknown"), -1);
    public static final MessageType MISS_CLASSES = new MessageType(i18n.getString("ErrorFormatter.error.missing.classes"), 1);
    public static final MessageType MISS_NESTED_CLASSES = new MessageType(i18n.getString("ErrorFormatter.error.missing.nested.classes"), 2);
    public static final MessageType MISS_SUPERCLASSES = new MessageType(i18n.getString("ErrorFormatter.error.missing.superclasses"), 3);
    public static final MessageType MISS_FIELDS = new MessageType(i18n.getString("ErrorFormatter.error.missing.field"), 4);
    public static final MessageType MISS_CONSTRUCTORS = new MessageType(i18n.getString("ErrorFormatter.error.missing.construct"), 5);
    public static final MessageType MISS_METHS = new MessageType(i18n.getString("ErrorFormatter.error.missing.methods"), 6);
    public static final MessageType ADD_CLASSES = new MessageType(i18n.getString("ErrorFormatter.error.added.classes"), 7);
    public static final MessageType ADD_NESTED_CLASSES = new MessageType(i18n.getString("ErrorFormatter.error.added.nested.classes"), 8);
    public static final MessageType ADD_SUPCLASSES = new MessageType(i18n.getString("ErrorFormatter.error.added.superclasses"), 9);
    public static final MessageType ADD_FLD = new MessageType(i18n.getString("ErrorFormatter.error.added.field"), 10);
    public static final MessageType ADD_CONSTRUCTORS = new MessageType(i18n.getString("ErrorFormatter.error.added.construct"), 11);
    public static final MessageType ADD_METHS = new MessageType(i18n.getString("ErrorFormatter.error.added.methods"), 12);
    public static final MessageType ERROR_LINKERR = new MessageType(i18n.getString("ErrorFormatter.error.linkerror"), 18);
    public static final MessageType MISS_ANNO = new MessageType(i18n.getString("ErrorFormatter.error.missinganno.defn"), 21);
    public static final MessageType ADD_ANNO = new MessageType(i18n.getString("ErrorFormatter.error.addedanno.defn"), 22);
    public static final MessageType CHNG_SUPCLASSES_TOPOL = new MessageType(i18n.getString("ErrorFormatter.error.changedsuperclasses.topol"), 23);
    public static final MessageType CHNG_CLASSES_MEMBERS = new MessageType(i18n.getString("HumanErrorFormatter.error.change.clss.or.memb"), 24);

    @Override
    public int compareTo(MessageType mt) {
        if (this.id == mt.id) {
            return 0;
        }
        return this.id - mt.id > 0 ? 1 : -1;
    }

    public boolean isWarning() {
        return this.thisIsWarning;
    }

    public MessageType(String key, int id) {
        this(key, id, false);
    }

    private MessageType(String key, int id, boolean isWarning) {
        this.text = key;
        this.id = id;
        this.thisIsWarning = isWarning;
    }

    public String toString() {
        return this.getLocMessage();
    }

    String getLocMessage() {
        return this.text;
    }

    public static MessageType getMissingMessageType(MemberType type) {
        if (type == MemberType.CLASS) {
            return MISS_CLASSES;
        }
        if (type == MemberType.INNER) {
            return MISS_NESTED_CLASSES;
        }
        if (type == MemberType.SUPERCLASS || type == MemberType.SUPERINTERFACE) {
            return MISS_SUPERCLASSES;
        }
        if (type == MemberType.FIELD) {
            return MISS_FIELDS;
        }
        if (type == MemberType.CONSTRUCTOR) {
            return MISS_CONSTRUCTORS;
        }
        if (type == MemberType.METHOD) {
            return MISS_METHS;
        }
        return ERROR_UNKNOWN;
    }

    public static MessageType getAddedMessageType(MemberType type) {
        if (type == MemberType.CLASS) {
            return ADD_CLASSES;
        }
        if (type == MemberType.INNER) {
            return ADD_NESTED_CLASSES;
        }
        if (type == MemberType.SUPERCLASS || type == MemberType.SUPERINTERFACE) {
            return ADD_SUPCLASSES;
        }
        if (type == MemberType.FIELD) {
            return ADD_FLD;
        }
        if (type == MemberType.CONSTRUCTOR) {
            return ADD_CONSTRUCTORS;
        }
        if (type == MemberType.METHOD) {
            return ADD_METHS;
        }
        return ERROR_UNKNOWN;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageType other = (MessageType)obj;
        return this.id == other.id;
    }
}

