/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccessLogRequestHandler
extends LDAPListenerRequestHandler
implements SearchEntryTransformer {
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMATTERS = new ThreadLocal();
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> BUFFERS = new ThreadLocal();
    private final AtomicLong nextOperationID;
    private final ConcurrentHashMap<Integer, AtomicLong> entryCounts = new ConcurrentHashMap();
    private final Handler logHandler;
    private final LDAPListenerClientConnection clientConnection;
    private final LDAPListenerRequestHandler requestHandler;

    public AccessLogRequestHandler(Handler logHandler, LDAPListenerRequestHandler requestHandler) {
        Validator.ensureNotNull(logHandler, requestHandler);
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.nextOperationID = null;
        this.clientConnection = null;
    }

    private AccessLogRequestHandler(Handler logHandler, LDAPListenerRequestHandler requestHandler, LDAPListenerClientConnection clientConnection) {
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.clientConnection = clientConnection;
        this.nextOperationID = new AtomicLong(0L);
    }

    @Override
    public AccessLogRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        AccessLogRequestHandler h = new AccessLogRequestHandler(this.logHandler, this.requestHandler.newInstance(connection), connection);
        connection.addSearchEntryTransformer(h);
        StringBuilder b = h.getConnectionHeader("CONNECT");
        Socket s = connection.getSocket();
        b.append(" from=\"");
        b.append(s.getInetAddress().getHostAddress());
        b.append(':');
        b.append(s.getPort());
        b.append("\" to=\"");
        b.append(s.getLocalAddress().getHostAddress());
        b.append(':');
        b.append(s.getLocalPort());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return h;
    }

    @Override
    public void closeInstance() {
        StringBuilder b = this.getConnectionHeader("DISCONNECT");
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.closeInstance();
    }

    @Override
    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        StringBuilder b = this.getRequestHeader("ABANDON", this.nextOperationID.getAndIncrement(), messageID);
        b.append(" idToAbandon=");
        b.append(request.getIDToAbandon());
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("ADD", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processAddRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        AddResponseProtocolOp protocolOp = responseMessage.getAddResponseProtocolOp();
        this.generateResponse(b, "ADD", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("BIND", opID, messageID);
        b.append(" version=");
        b.append(request.getVersion());
        b.append(" dn=\"");
        b.append(request.getBindDN());
        b.append("\" authType=\"");
        switch (request.getCredentialsType()) {
            case -128: {
                b.append("SIMPLE");
                break;
            }
            case -93: {
                b.append("SASL ");
                b.append(request.getSASLMechanism());
            }
        }
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processBindRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        BindResponseProtocolOp protocolOp = responseMessage.getBindResponseProtocolOp();
        this.generateResponse(b, "BIND", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("COMPARE", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append("\" attr=\"");
        b.append(request.getAttributeName());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processCompareRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        CompareResponseProtocolOp protocolOp = responseMessage.getCompareResponseProtocolOp();
        this.generateResponse(b, "COMPARE", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("DELETE", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processDeleteRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        DeleteResponseProtocolOp protocolOp = responseMessage.getDeleteResponseProtocolOp();
        this.generateResponse(b, "DELETE", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("EXTENDED", opID, messageID);
        b.append(" requestOID=\"");
        b.append(request.getOID());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processExtendedRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ExtendedResponseProtocolOp protocolOp = responseMessage.getExtendedResponseProtocolOp();
        this.generateResponse(b, "EXTENDED", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        String responseOID = protocolOp.getResponseOID();
        if (responseOID != null) {
            b.append(" responseOID=\"");
            b.append(responseOID);
            b.append('\"');
        }
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("MODIFY", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyResponseProtocolOp protocolOp = responseMessage.getModifyResponseProtocolOp();
        this.generateResponse(b, "MODIFY", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("MODDN", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append("\" newRDN=\"");
        b.append(request.getNewRDN());
        b.append("\" deleteOldRDN=");
        b.append(request.deleteOldRDN());
        String newSuperior = request.getNewSuperiorDN();
        if (newSuperior != null) {
            b.append(" newSuperior=\"");
            b.append(newSuperior);
            b.append('\"');
        }
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyDNRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyDNResponseProtocolOp protocolOp = responseMessage.getModifyDNResponseProtocolOp();
        this.generateResponse(b, "MODDN", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("SEARCH", opID, messageID);
        b.append(" base=\"");
        b.append(request.getBaseDN());
        b.append("\" scope=");
        b.append(request.getScope().intValue());
        b.append(" filter=\"");
        request.getFilter().toString(b);
        b.append("\" attrs=\"");
        List<String> attrList = request.getAttributes();
        if (attrList.isEmpty()) {
            b.append("ALL");
        } else {
            Iterator<String> iterator = attrList.iterator();
            while (iterator.hasNext()) {
                b.append(iterator.next());
                if (!iterator.hasNext()) continue;
                b.append(',');
            }
        }
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        AtomicLong l = new AtomicLong(0L);
        this.entryCounts.put(messageID, l);
        try {
            long startTimeNanos = System.nanoTime();
            LDAPMessage responseMessage = this.requestHandler.processSearchRequest(messageID, request, controls);
            long eTimeNanos = System.nanoTime() - startTimeNanos;
            SearchResultDoneProtocolOp protocolOp = responseMessage.getSearchResultDoneProtocolOp();
            this.generateResponse(b, "SEARCH", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
            b.append(" entriesReturned=");
            b.append(l.get());
            this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
            this.logHandler.flush();
            LDAPMessage lDAPMessage = responseMessage;
            return lDAPMessage;
        }
        finally {
            this.entryCounts.remove(messageID);
        }
    }

    @Override
    public void processUnbindRequest(int messageID, UnbindRequestProtocolOp request, List<Control> controls) {
        StringBuilder b = this.getRequestHeader("UNBIND", this.nextOperationID.getAndIncrement(), messageID);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.processUnbindRequest(messageID, request, controls);
    }

    private static StringBuilder getBuffer() {
        StringBuilder b = BUFFERS.get();
        if (b == null) {
            b = new StringBuilder();
            BUFFERS.set(b);
        } else {
            b.setLength(0);
        }
        return b;
    }

    private static void addTimestamp(StringBuilder buffer) {
        SimpleDateFormat dateFormat = DATE_FORMATTERS.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss Z']'");
            DATE_FORMATTERS.set(dateFormat);
        }
        buffer.append(dateFormat.format(new Date()));
    }

    private StringBuilder getConnectionHeader(String messageType) {
        StringBuilder b = AccessLogRequestHandler.getBuffer();
        AccessLogRequestHandler.addTimestamp(b);
        b.append(' ');
        b.append(messageType);
        b.append(" conn=");
        b.append(this.clientConnection.getConnectionID());
        return b;
    }

    private StringBuilder getRequestHeader(String opType, long opID, int msgID) {
        StringBuilder b = AccessLogRequestHandler.getBuffer();
        AccessLogRequestHandler.addTimestamp(b);
        b.append(' ');
        b.append(opType);
        b.append(" REQUEST conn=");
        b.append(this.clientConnection.getConnectionID());
        b.append(" op=");
        b.append(opID);
        b.append(" msgID=");
        b.append(msgID);
        return b;
    }

    private void generateResponse(StringBuilder b, String opType, long opID, int msgID, int resultCode, String diagnosticMessage, String matchedDN, List<String> referralURLs, long eTimeNanos) {
        DecimalFormat f;
        b.setLength(0);
        AccessLogRequestHandler.addTimestamp(b);
        b.append(' ');
        b.append(opType);
        b.append(" RESULT conn=");
        b.append(this.clientConnection.getConnectionID());
        b.append(" op=");
        b.append(opID);
        b.append(" msgID=");
        b.append(msgID);
        b.append(" resultCode=");
        b.append(resultCode);
        if (diagnosticMessage != null) {
            b.append(" diagnosticMessage=\"");
            b.append(diagnosticMessage);
            b.append('\"');
        }
        if (matchedDN != null) {
            b.append(" matchedDN=\"");
            b.append(matchedDN);
            b.append('\"');
        }
        if (!referralURLs.isEmpty()) {
            b.append(" referralURLs=\"");
            Iterator<String> iterator = referralURLs.iterator();
            while (iterator.hasNext()) {
                b.append(iterator.next());
                if (!iterator.hasNext()) continue;
                b.append(',');
            }
            b.append('\"');
        }
        if ((f = DECIMAL_FORMATTERS.get()) == null) {
            f = new DecimalFormat("0.000");
            DECIMAL_FORMATTERS.set(f);
        }
        b.append(" etime=");
        b.append(f.format((double)eTimeNanos / 1000000.0));
    }

    @Override
    public ObjectPair<SearchResultEntryProtocolOp, Control[]> transformEntry(int messageID, SearchResultEntryProtocolOp entry, Control[] controls) {
        AtomicLong l = this.entryCounts.get(messageID);
        if (l != null) {
            l.incrementAndGet();
        }
        return new ObjectPair<SearchResultEntryProtocolOp, Control[]>(entry, controls);
    }
}

