/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.IntermediateResponseTransformer;
import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.listener.SearchReferenceTransformer;
import com.unboundid.ldap.listener.interceptor.InMemoryOperationInterceptor;
import com.unboundid.ldap.listener.interceptor.InterceptedAddOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedCompareOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedDeleteOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedExtendedOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedIntermediateResponse;
import com.unboundid.ldap.listener.interceptor.InterceptedModifyDNOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedModifyOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSASLBindOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchEntry;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchReference;
import com.unboundid.ldap.listener.interceptor.InterceptedSimpleBindOperation;
import com.unboundid.ldap.listener.interceptor.InterceptorMessages;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryOperationInterceptorRequestHandler
extends LDAPListenerRequestHandler
implements IntermediateResponseTransformer,
SearchEntryTransformer,
SearchReferenceTransformer {
    private final InMemoryOperationInterceptor[] interceptors;
    private final LDAPListenerClientConnection connection;
    private final LDAPListenerRequestHandler wrappedHandler;
    private final Map<Integer, InterceptedOperation> activeOperations;

    public InMemoryOperationInterceptorRequestHandler(List<InMemoryOperationInterceptor> interceptors, LDAPListenerRequestHandler wrappedHandler) {
        this.wrappedHandler = wrappedHandler;
        this.interceptors = new InMemoryOperationInterceptor[interceptors.size()];
        interceptors.toArray(this.interceptors);
        this.connection = null;
        this.activeOperations = new HashMap<Integer, InterceptedOperation>(5);
    }

    private InMemoryOperationInterceptorRequestHandler(InMemoryOperationInterceptor[] interceptors, LDAPListenerRequestHandler wrappedHandler, LDAPListenerClientConnection connection) {
        this.interceptors = interceptors;
        this.wrappedHandler = wrappedHandler;
        this.connection = connection;
        this.activeOperations = new HashMap<Integer, InterceptedOperation>(5);
    }

    @Override
    public InMemoryOperationInterceptorRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        InMemoryOperationInterceptorRequestHandler handler = new InMemoryOperationInterceptorRequestHandler(this.interceptors, this.wrappedHandler.newInstance(connection), connection);
        connection.addSearchEntryTransformer(handler);
        connection.addSearchReferenceTransformer(handler);
        connection.addIntermediateResponseTransformer(handler);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        InterceptedAddOperation op = new InterceptedAddOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processAddRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processAddRequest(messageID, new AddRequestProtocolOp((AddRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getAddResponseProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processAddResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        if (request.getCredentialsType() == -128) {
            InterceptedSimpleBindOperation op = new InterceptedSimpleBindOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
            this.activeOperations.put(messageID, op);
            try {
                for (InMemoryOperationInterceptor i : this.interceptors) {
                    try {
                        i.processSimpleBindRequest(op);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                        this.activeOperations.remove(messageID);
                        return lDAPMessage;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null, null), new Control[0]);
                        this.activeOperations.remove(messageID);
                        return lDAPMessage;
                    }
                }
                LDAPMessage resultMessage = this.wrappedHandler.processBindRequest(messageID, new BindRequestProtocolOp(op.getRequest()), op.getRequest().getControlList());
                op.setResult(resultMessage.getBindResponseProtocolOp().toBindResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
                for (InMemoryOperationInterceptor i : this.interceptors) {
                    try {
                        i.processSimpleBindResult(op);
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                        LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e2)), null, null), new Control[0]);
                        this.activeOperations.remove(messageID);
                        return lDAPMessage;
                    }
                }
                Object arr$ = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
                return arr$;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.activeOperations.remove(messageID);
            }
        }
        InterceptedSASLBindOperation op = new InterceptedSASLBindOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processSASLBindRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage e2 = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return e2;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage e2 = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null, null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return e2;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processBindRequest(messageID, new BindRequestProtocolOp(op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getBindResponseProtocolOp().toBindResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processSASLBindResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null, null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        InterceptedCompareOperation op = new InterceptedCompareOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processCompareRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processCompareRequest(messageID, new CompareRequestProtocolOp((CompareRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getCompareResponseProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processCompareResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        InterceptedDeleteOperation op = new InterceptedDeleteOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processDeleteRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processDeleteRequest(messageID, new DeleteRequestProtocolOp((DeleteRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getDeleteResponseProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processDeleteResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        InterceptedExtendedOperation op = new InterceptedExtendedOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processExtendedRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null, null, null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processExtendedRequest(messageID, new ExtendedRequestProtocolOp(op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getExtendedResponseProtocolOp().toExtendedResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processExtendedResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null, null, null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        InterceptedModifyOperation op = new InterceptedModifyOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processModifyRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processModifyRequest(messageID, new ModifyRequestProtocolOp((ModifyRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getModifyResponseProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processModifyResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        InterceptedModifyDNOperation op = new InterceptedModifyDNOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processModifyDNRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processModifyDNRequest(messageID, new ModifyDNRequestProtocolOp((ModifyDNRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getModifyDNResponseProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processModifyDNResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        InterceptedSearchOperation op = new InterceptedSearchOperation(this.connection, messageID, request, InMemoryOperationInterceptorRequestHandler.toArray(controls));
        this.activeOperations.put(messageID, op);
        try {
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processSearchRequest(op);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.toLDAPResult()), le.getResponseControls());
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_REQUEST_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage resultMessage = this.wrappedHandler.processSearchRequest(messageID, new SearchRequestProtocolOp((SearchRequest)op.getRequest()), op.getRequest().getControlList());
            op.setResult(resultMessage.getSearchResultDoneProtocolOp().toLDAPResult(InMemoryOperationInterceptorRequestHandler.toArray(resultMessage.getControls())));
            for (InMemoryOperationInterceptor i : this.interceptors) {
                try {
                    i.processSearchResult(op);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(80, null, InterceptorMessages.ERR_DS_INTERCEPTOR_RESULT_ERROR.get(String.valueOf(op), i.getClass().getName(), StaticUtils.getExceptionMessage(e)), null), new Control[0]);
                    this.activeOperations.remove(messageID);
                    return lDAPMessage;
                }
            }
            LDAPMessage lDAPMessage = new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(op.getResult()), op.getResult().getResponseControls());
            return lDAPMessage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.activeOperations.remove(messageID);
        }
    }

    @Override
    public ObjectPair<SearchResultEntryProtocolOp, Control[]> transformEntry(int messageID, SearchResultEntryProtocolOp entry, Control[] controls) {
        InterceptedSearchOperation op = (InterceptedSearchOperation)this.activeOperations.get(messageID);
        if (op == null) {
            return new ObjectPair<SearchResultEntryProtocolOp, Control[]>(entry, controls);
        }
        InterceptedSearchEntry e = new InterceptedSearchEntry(op, entry, controls);
        for (InMemoryOperationInterceptor i : this.interceptors) {
            try {
                i.processSearchEntry(e);
                if (e.getSearchEntry() != null) continue;
                return null;
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                return null;
            }
        }
        return new ObjectPair<SearchResultEntryProtocolOp, Control[]>(new SearchResultEntryProtocolOp(e.getSearchEntry()), e.getSearchEntry().getControls());
    }

    @Override
    public ObjectPair<SearchResultReferenceProtocolOp, Control[]> transformReference(int messageID, SearchResultReferenceProtocolOp reference, Control[] controls) {
        InterceptedSearchOperation op = (InterceptedSearchOperation)this.activeOperations.get(messageID);
        if (op == null) {
            return new ObjectPair<SearchResultReferenceProtocolOp, Control[]>(reference, controls);
        }
        InterceptedSearchReference r = new InterceptedSearchReference(op, reference, controls);
        for (InMemoryOperationInterceptor i : this.interceptors) {
            try {
                i.processSearchReference(r);
                if (r.getSearchReference() != null) continue;
                return null;
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                return null;
            }
        }
        return new ObjectPair<SearchResultReferenceProtocolOp, Control[]>(new SearchResultReferenceProtocolOp(r.getSearchReference()), r.getSearchReference().getControls());
    }

    @Override
    public ObjectPair<IntermediateResponseProtocolOp, Control[]> transformIntermediateResponse(int messageID, IntermediateResponseProtocolOp response, Control[] controls) {
        InterceptedOperation op = this.activeOperations.get(messageID);
        if (op == null) {
            return new ObjectPair<IntermediateResponseProtocolOp, Control[]>(response, controls);
        }
        InterceptedIntermediateResponse r = new InterceptedIntermediateResponse(op, response, controls);
        for (InMemoryOperationInterceptor i : this.interceptors) {
            try {
                i.processIntermediateResponse(r);
                if (r.getIntermediateResponse() != null) continue;
                return null;
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                return null;
            }
        }
        return new ObjectPair<IntermediateResponseProtocolOp, Control[]>(new IntermediateResponseProtocolOp(r.getIntermediateResponse()), r.getIntermediateResponse().getControls());
    }

    private static Control[] toArray(List<Control> controls) {
        if (controls == null || controls.isEmpty()) {
            return StaticUtils.NO_CONTROLS;
        }
        Control[] controlArray = new Control[controls.size()];
        return controls.toArray(controlArray);
    }
}

