/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RedactAttributeTransformation
implements EntryTransformation,
LDIFChangeRecordTransformation {
    private final boolean preserveValueCount;
    private final boolean redactDNAttributes;
    private final Schema schema;
    private final Set<String> attributes;

    public RedactAttributeTransformation(Schema schema, boolean redactDNAttributes, boolean preserveValueCount, String ... attributes) {
        this(schema, redactDNAttributes, preserveValueCount, StaticUtils.toList(attributes));
    }

    public RedactAttributeTransformation(Schema schema, boolean redactDNAttributes, boolean preserveValueCount, Collection<String> attributes) {
        this.redactDNAttributes = redactDNAttributes;
        this.preserveValueCount = preserveValueCount;
        Schema s = schema;
        if (s == null) {
            try {
                s = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s;
        HashSet<String> attrNames = new HashSet<String>(3 * attributes.size());
        for (String attrName : attributes) {
            AttributeTypeDefinition at;
            String baseName = Attribute.getBaseName(StaticUtils.toLowerCase(attrName));
            attrNames.add(baseName);
            if (s == null || (at = s.getAttributeType(baseName)) == null) continue;
            attrNames.add(StaticUtils.toLowerCase(at.getOID()));
            for (String name : at.getNames()) {
                attrNames.add(StaticUtils.toLowerCase(name));
            }
        }
        this.attributes = Collections.unmodifiableSet(attrNames);
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        String newDN = this.redactDNAttributes ? this.redactDN(e.getDN()) : e.getDN();
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            String baseName = StaticUtils.toLowerCase(a.getBaseName());
            if (this.attributes.contains(baseName)) {
                if (this.preserveValueCount && a.size() > 1) {
                    ASN1OctetString[] values = new ASN1OctetString[a.size()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = new ASN1OctetString("***REDACTED" + (i + 1) + "***");
                    }
                    newAttributes.add(new Attribute(a.getName(), values));
                    continue;
                }
                newAttributes.add(new Attribute(a.getName(), "***REDACTED***"));
                continue;
            }
            if (this.redactDNAttributes && this.schema != null && MatchingRule.selectEqualityMatchingRule(baseName, this.schema) instanceof DistinguishedNameMatchingRule) {
                String[] originalValues = a.getValues();
                String[] newValues = new String[originalValues.length];
                for (int i = 0; i < originalValues.length; ++i) {
                    newValues[i] = this.redactDN(originalValues[i]);
                }
                newAttributes.add(new Attribute(a.getName(), this.schema, newValues));
                continue;
            }
            newAttributes.add(a);
        }
        return new Entry(newDN, this.schema, newAttributes);
    }

    private String redactDN(String dn) {
        if (dn == null) {
            return null;
        }
        try {
            boolean changeApplied = false;
            RDN[] originalRDNs = new DN(dn).getRDNs();
            RDN[] newRDNs = new RDN[originalRDNs.length];
            for (int i = 0; i < originalRDNs.length; ++i) {
                String[] names = originalRDNs[i].getAttributeNames();
                String[] originalValues = originalRDNs[i].getAttributeValues();
                String[] newValues = new String[originalValues.length];
                for (int j = 0; j < names.length; ++j) {
                    if (this.attributes.contains(StaticUtils.toLowerCase(names[j]))) {
                        changeApplied = true;
                        newValues[j] = "***REDACTED***";
                        continue;
                    }
                    newValues[j] = originalValues[j];
                }
                newRDNs[i] = new RDN(names, newValues, this.schema);
            }
            if (changeApplied) {
                return new DN(newRDNs).toString();
            }
            return dn;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return dn;
        }
    }

    @Override
    public LDIFChangeRecord transformChangeRecord(LDIFChangeRecord r) {
        if (r == null) {
            return null;
        }
        if (r instanceof LDIFAddChangeRecord) {
            LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)r;
            return new LDIFAddChangeRecord(this.transformEntry(addRecord.getEntryToAdd()), addRecord.getControls());
        }
        if (r instanceof LDIFDeleteChangeRecord) {
            if (this.redactDNAttributes) {
                LDIFDeleteChangeRecord deleteRecord = (LDIFDeleteChangeRecord)r;
                return new LDIFDeleteChangeRecord(this.redactDN(deleteRecord.getDN()), deleteRecord.getControls());
            }
            return r;
        }
        if (r instanceof LDIFModifyChangeRecord) {
            LDIFModifyChangeRecord modifyRecord = (LDIFModifyChangeRecord)r;
            String newDN = this.redactDNAttributes ? this.redactDN(modifyRecord.getDN()) : modifyRecord.getDN();
            Modification[] originalMods = modifyRecord.getModifications();
            Modification[] newMods = new Modification[originalMods.length];
            for (int i = 0; i < originalMods.length; ++i) {
                int j;
                Object[] newValues;
                Object[] originalValues;
                Modification m = originalMods[i];
                if (!m.hasValue()) {
                    newMods[i] = m;
                    continue;
                }
                String attrName = StaticUtils.toLowerCase(Attribute.getBaseName(m.getAttributeName()));
                if (!this.attributes.contains(attrName)) {
                    if (this.redactDNAttributes && this.schema != null && MatchingRule.selectEqualityMatchingRule(attrName, this.schema) instanceof DistinguishedNameMatchingRule) {
                        originalValues = m.getValues();
                        newValues = new String[originalValues.length];
                        for (j = 0; j < originalValues.length; ++j) {
                            newValues[j] = this.redactDN((String)originalValues[j]);
                        }
                        newMods[i] = new Modification(m.getModificationType(), m.getAttributeName(), (String[])newValues);
                        continue;
                    }
                    newMods[i] = m;
                    continue;
                }
                originalValues = m.getRawValues();
                if (this.preserveValueCount && originalValues.length > 1) {
                    newValues = new ASN1OctetString[originalValues.length];
                    for (j = 0; j < originalValues.length; ++j) {
                        newValues[j] = new ASN1OctetString("***REDACTED" + (j + 1) + "***");
                    }
                    newMods[i] = new Modification(m.getModificationType(), m.getAttributeName(), (ASN1OctetString[])newValues);
                    continue;
                }
                newMods[i] = new Modification(m.getModificationType(), m.getAttributeName(), "***REDACTED***");
            }
            return new LDIFModifyChangeRecord(newDN, newMods, modifyRecord.getControls());
        }
        if (r instanceof LDIFModifyDNChangeRecord) {
            if (this.redactDNAttributes) {
                LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)r;
                return new LDIFModifyDNChangeRecord(this.redactDN(modDNRecord.getDN()), this.redactDN(modDNRecord.getNewRDN()), modDNRecord.deleteOldRDN(), this.redactDN(modDNRecord.getNewSuperiorDN()), modDNRecord.getControls());
            }
            return r;
        }
        return r;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translate(LDIFChangeRecord original, long firstLineNumber) {
        return this.transformChangeRecord(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }

    @Override
    public LDIFChangeRecord translateChangeRecordToWrite(LDIFChangeRecord original) {
        return this.transformChangeRecord(original);
    }
}

