/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.agent.AgentManager;
import java.io.IOException;
import java.io.PrintWriter;

public class PassiveAgentCommand
extends Command {
    public Status run(String[] args, PrintWriter err, PrintWriter out) {
        int i;
        String classPath = null;
        String host = null;
        int port = -1;
        String tag = null;
        boolean localizeArgs = false;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if ((args[i].equals("-cp") || args[i].equals("-classpath")) && i + 1 < args.length) {
                classPath = args[++i];
                continue;
            }
            if ((args[i].equals("-h") || args[i].equals("-host")) && i + 1 < args.length) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-m") || args[i].equals("-mapArgs")) {
                localizeArgs = true;
                continue;
            }
            if ((args[i].equals("-p") || args[i].equals("-port")) && i + 1 < args.length) {
                try {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return Status.error("bad port number: " + args[i]);
                }
            }
            if ((args[i].equals("-t") || args[i].equals("-tag")) && i + 1 < args.length) {
                tag = args[++i];
                continue;
            }
            return Status.error("Unrecognized option: " + args[i]);
        }
        if (i == args.length) {
            return Status.error("No command specified");
        }
        if (host == null) {
            return Status.error("No host specified");
        }
        String cmdClass = args[i++];
        String[] cmdArgs = new String[args.length - i];
        System.arraycopy(args, i, cmdArgs, 0, cmdArgs.length);
        if (tag == null) {
            tag = cmdClass;
        }
        try {
            AgentManager mgr = AgentManager.access();
            AgentManager.Task t = port == -1 ? mgr.connectToPassiveAgent(host) : mgr.connectToPassiveAgent(host, port);
            if (classPath != null) {
                t.setClassPath(classPath);
            }
            err.println("Executing command via " + t.getConnection().getName());
            return t.executeCommand(tag, cmdClass, cmdArgs, localizeArgs, err, out);
        }
        catch (IOException e) {
            return Status.error("Error accessing agent: " + e);
        }
    }
}

