/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RMIMBeanPropFileImpl.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import javax.jbi.component.ComponentContext;
import java.util.*;
import java.io.*;

public class RMIMBeanPropFileImpl extends RMIMBeanImpl {

    public void saveProps(ComponentContext ctx) throws Exception {
	String header = "Result BC Props";
	String installRoot = ctx.getInstallRoot();
	File propFile = new File(installRoot + File.separator + "config.props");
	Properties props = new Properties();
	props.setProperty(Constants.RMI_PORT_NAME, getRmiPort().toString());
	props.setProperty(Constants.RMI_HOST_NAME, getRmiHost());
	props.setProperty(Constants.RMI_BIND_NAME, getRmiBindName());
	OutputStream os = new FileOutputStream(propFile);
	try {
	    props.store(os, header);
	} finally {
	    try { os.close(); } catch(Exception e) {}
	}
    }

}
