/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/


package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkException;
import com.sun.ts.tests.common.connector.util.*;
import javax.resource.spi.work.DistributableWork;


public class DistributedWorkImpl implements DistributableWork
{

    private WorkManager wm;

    public DistributedWorkImpl(WorkManager wm)
    {
        this.wm = wm;

        ConnectorStatus.getConnectorStatus().logAPI("DistributedWorkImpl.constructor", "", "");
        System.out.println("DistributedWorkImpl.constructor");
    }

    @Override
    public void release()
    {
        ConnectorStatus.getConnectorStatus().logAPI("DistributedWorkImpl.release", "", "");
        System.out.println("DistributedWorkImpl.release");
    }

    public void run()
    {
        try {
            ConnectorStatus.getConnectorStatus().logAPI("DistributedWorkImpl.run", "", "");
            System.out.println("DistributedWorkImpl.run");
            NestWork nw = new NestWork();
            wm.doWork(nw);
        } catch (WorkException e) {
            // this could mean work completed or work rejected or something else.
            System.out.println("DistributedWorkImpl WorkException caught");
        }
    }

}
