 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: AppManagedNoTxVehicleRunner.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.appmanagedNoTx;

import java.util.Properties;
import com.sun.ts.lib.harness.EETest;
import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;

public class AppManagedNoTxVehicleRunner implements VehicleRunnable {
    public static final String APPMANAGEDNOTX_REF_NAME = "java:comp/env/ejb/AppManagedNoTxVehicleBean";
    
    public Status run(String[] args, Properties props) {
        Status sTestStatus = null;
        try {
            TSNamingContext jc= new TSNamingContext();
            AppManagedNoTxVehicleIF bean = (AppManagedNoTxVehicleIF) jc.lookup(APPMANAGEDNOTX_REF_NAME);
            TestUtil.logTrace("application-managed resource-local runner looked up vehicle: " + bean);
            sTestStatus = (bean.runTest(args, props)).toStatus();
        } catch(Exception e) {
            TestUtil.logErr("Test failed.", e);
            sTestStatus = Status.failed("Test run in application-managed resource-local vehicle failed.");
        }
        return sTestStatus;
    }
}

