 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: TimerEJB.java 62595 2011-04-20 20:38:55Z kgrucci $
 */


package com.sun.ts.tests.ejb30.common.allowed.stateful;


import com.sun.ts.tests.ejb30.common.helper.TLogger;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TimerHandle;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless(name="TimerEJB")
@Local({TimerLocalIF.class})        
public class TimerEJB implements TimerLocalIF {
    private SessionContext sessionContext;
     
    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sessionContext = sc;
    }

    @Timeout
    @TransactionAttribute(TransactionAttributeType.REQUIRES_NEW)
    private void ejbTimeout(javax.ejb.Timer timer) {
    }
    
//    @TransactionAttribute(TransactionAttributeType.REQUIRES_NEW)
    public TimerHandle startTimer(long duration, String info) {
        try {
            javax.ejb.TimerService ts = sessionContext.getTimerService();
            TLogger.logTrace("create Timer");
            javax.ejb.Timer t = ts.createTimer(duration, info);
            return t.getHandle();
        } catch (Exception e) {
            TLogger.printStackTrace(e);
            throw new EJBException("startTimer:" +e);
        }
    }
    
    public void findAndCancelTimer() {
        Collection ccol = null;
        try {
            TLogger.logTrace("findAndCancelTimer method entered");
            javax.ejb.TimerService ts = sessionContext.getTimerService();
            TLogger.logTrace("getTimers");
            ccol = ts.getTimers();
            if (!ccol.isEmpty()) {
                TLogger.logTrace("Timer Collection Not Empty");
                Iterator i = ccol.iterator();
                while (i.hasNext()) {
                    TLogger.logTrace("Looking up next timer");
                    javax.ejb.Timer t = (javax.ejb.Timer)i.next();
                    TLogger.logTrace("Cancel timer with info: " + t.getInfo() );
                    t.cancel();
                }
            } else {
                TLogger.logTrace("Timer Collection is Empty");
            }
        } catch (Exception e) {
            //ignore
        }
    }
    
    // ===========================================================
    
}

