/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: CalculatorException.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

import java.io.Serializable;


/**
 * An application exception for calculator example.  It can be used
 * to test that the methods of the business interface may declare
 * arbitrary application exceptions.
 * 
 * @author Cheng Fang
 */
public class CalculatorException extends Exception implements Serializable {

    public CalculatorException() {
        super();
    }

    /**
     * @param message
     */
    public CalculatorException(String message) {
        super(message);
    }

    /**
     * @param message
     * @param cause
     */
    public CalculatorException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * @param cause
     */
    public CalculatorException(Throwable cause) {
        super(cause);
    }

}
