/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: InterceptorBaseBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;
import javax.annotation.Resource;
import org.omg.CORBA.ORB;

abstract public class InterceptorBaseBase {
    protected static final String NOT_INJECTED = "NOT_INJECTED";
    protected static final String POSTCONSTRUCT_CALLS_IN_CONTEXTDATA = 
            "POSTCONSTRUCT_CALLS_IN_CONTEXTDATA";
    
    @Resource()
    private ORB orbInBaseBase;
    
    abstract protected String getInjectedLocation();
    
    protected String getInjectedBaseBaseLocation() {
        String result = (orbInBaseBase == null) ? NOT_INJECTED : "BASEBASE";
        return result;
    }
    
    /**
     * Note that this method may be overridden by subclasses.  If so, the value
     * returned may be different from the shortName defined in the current
     * enclosing class.  That is why we need to pass a symbol (same as shortName)
     * to myCreate0(InvocatioinContext, String symbol), to force a hardcoded
     * value.
     */
    protected String getShortName() { return "BASEBASE";}
    
}
