/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: InterceptorC.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.omg.CORBA.ORB;

/**
 * A callback listerner for stateless session beans. It uses ejb* for method
 * names. Callback methods may throw RuntimeException.  They are declared in
 * the throws list, though not necessary.
 */
public class InterceptorC extends InterceptorBase {
    @Resource()
    private ORB orb;
    
    public InterceptorC() {
        super();
    }
    
    public String getInjectedLocation() {
        String result = (orb == null) ? NOT_INJECTED : "C";
        return result;
    }
    
    @Override
    protected String getShortName() { return "C";}
    
    @PostConstruct
    protected void myCreate(InvocationContext inv) throws RuntimeException {
        myCreate0(inv, "C");
    }
    
    @PreDestroy
    protected void myRemove(InvocationContext inv) throws RuntimeException {
        super.myRemove(inv);
    }
    
    @AroundInvoke
    protected Object intercept(InvocationContext inv) throws Exception {
        return super.intercept(inv);
    }
}
