/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GreetingBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.generics;

import java.util.Arrays;
import java.util.List;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

public abstract class GreetingBeanBase implements RemoteIntGreetingIF, LocalIntGreetingIF, ParameterizedIF {

    @TransactionAttribute(TransactionAttributeType.MANDATORY)
    public Integer negate(Integer i) {
        return i - i - i;
    }

    @TransactionAttribute(TransactionAttributeType.MANDATORY)
    public Integer greet(Integer t) {
        return t;
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.ParameterizedIF#parameterizedParam(java.util.List)
     */
    @TransactionAttribute(TransactionAttributeType.MANDATORY)
    public void parameterizedParam(List<String> ls) {
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.ParameterizedIF#parameterizedReturn(int)
     */
    @TransactionAttribute(TransactionAttributeType.MANDATORY)
    public List<String> parameterizedReturn(int i) {
        return Arrays.asList(String.valueOf(i));
    }
}
