/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.registry.JAXRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.ReadSystemPropsPrivilegedAction;

public abstract class AbstractProperties {
    protected static final String DEFAULT_OMAR_HOME = "omar";
    protected static final String OMAR_HOME_KEY = "omar.home";
    protected static Log log = LogFactory.getLog((String)"org.freebxml.omar.common.Properties");
    protected Properties props = new Properties();

    protected AbstractProperties() {
    }

    protected static String initHomeDir(String propName, File homeDir) {
        try {
            if (!homeDir.exists()) {
                if (!homeDir.mkdirs()) {
                    throw new RuntimeException("Cannot create '" + propName + "' directory: " + homeDir.getPath());
                }
            } else if (!homeDir.isDirectory()) {
                throw new RuntimeException("Property '" + propName + "' should point to a directory: " + homeDir.getPath());
            }
            String homeDirStr = homeDir.getCanonicalPath();
            return homeDirStr;
        }
        catch (SecurityException se) {
            throw new RuntimeException("Failed to create/access '" + propName + "': " + homeDir.getPath() + ": " + se.toString());
        }
        catch (IOException io) {
            throw new RuntimeException("Failed to create/access '" + propName + "': " + homeDir.getPath() + ": " + io.toString());
        }
    }

    protected static void initOmarHomeDir(Properties properties) {
        String omarHome = AbstractProperties.getOmarHome(properties);
        File omarHomeFile = new File(omarHome);
        AbstractProperties.initHomeDir(OMAR_HOME_KEY, omarHomeFile);
        properties.put(OMAR_HOME_KEY, omarHome);
    }

    protected static void substituteVariables(Properties properties, String oldKeySubstring, String newKeySubstring) {
        int oldKeySubstringSize = oldKeySubstring.length();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (!key.startsWith("omar.")) continue;
            int index = -1;
            boolean modified = false;
            while ((index = value.indexOf(oldKeySubstring)) != -1) {
                value = value.substring(0, index) + newKeySubstring + value.substring(index + oldKeySubstringSize);
                modified = true;
            }
            if (!modified) continue;
            properties.put(key, value);
        }
    }

    protected static String substituteVariable(String value, String oldKeySubstring, String newKeySubstring) {
        int index;
        if (value == null) {
            return null;
        }
        int oldKeySubstringSize = oldKeySubstring.length();
        while ((index = value.indexOf(oldKeySubstring)) != -1) {
            value = value.substring(0, index) + newKeySubstring + value.substring(index + oldKeySubstringSize);
        }
        return value;
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public String getProperty(String propertyName, String def) {
        return this.props.getProperty(propertyName, def);
    }

    public Iterator getPropertyNamesStartingWith(String prefix) {
        LinkedList<String> lst = new LinkedList<String>();
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith(prefix)) continue;
            lst.add(propertyName);
        }
        return lst.iterator();
    }

    protected abstract void initProperties();

    protected abstract Properties loadProperties(Properties var1);

    public void reloadProperties() {
        this.initProperties();
    }

    protected abstract void loadDefaultProperties(Properties var1);

    protected static boolean loadResourceProperties(ClassLoader classLoader, Properties properties, String resourceName) {
        AbstractProperties.logInfo("Load props from classpath: " + resourceName);
        try {
            InputStream is = classLoader.getResourceAsStream(resourceName);
            if (is == null) {
                throw new JAXRException("Property resource " + resourceName + " not found in classpath");
            }
            properties.load(is);
            is.close();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Ignoring " + resourceName + " due to exception " + e.toString()));
            return false;
        }
    }

    protected static boolean loadFileProperties(Properties properties, File file) {
        AbstractProperties.logInfo("Load props from file: " + file.getPath());
        try {
            FileInputStream is = new FileInputStream(file);
            properties.load(is);
            ((InputStream)is).close();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Ignoring " + file.getPath() + " due to exception " + e.toString()));
            return false;
        }
    }

    protected static boolean loadSystemProperties(Properties properties) {
        AbstractProperties.logInfo("Load props from system props.");
        try {
            AccessController.doPrivileged(new ReadSystemPropsPrivilegedAction(properties));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Properties getSystemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }

    protected static void logProperties(String propsName, Properties props) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"==================================================");
            log.debug((Object)(propsName + ":"));
            Iterator<Object> names = new TreeSet<Object>(props.keySet()).iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = props.getProperty(name);
                log.debug((Object)(name + "=" + value));
            }
            log.debug((Object)"==================================================");
        }
    }

    public Properties cloneProperties() {
        Properties clone = new Properties();
        clone.putAll((Map<?, ?>)this.props);
        return clone;
    }

    protected static String getOmarHome(Properties properties) {
        String omarHome = properties.getProperty(OMAR_HOME_KEY);
        omarHome = System.getProperty(OMAR_HOME_KEY, omarHome);
        if ((omarHome = AbstractProperties.substituteVariable(omarHome, "$user.home", AbstractProperties.getUserHome())) == null) {
            throw new RuntimeException("Required property 'omar.home' not defined.");
        }
        return omarHome;
    }

    protected static String getUserHome() {
        return System.getProperty("user.home");
    }

    protected static void logInfo(String msg) {
        log.info((Object)msg);
    }

    protected static void logError(String msg) {
        log.error((Object)msg);
    }

    public void put(Object key, Object value) {
        this.props.put(key, value);
    }
}

