/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.registry.JAXRException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.freebxml.omar.common.CanonicalConstants;
import org.freebxml.omar.common.ReferenceInfo;
import org.freebxml.omar.common.Utility;
import org.oasis.ebxml.registry.bindings.lcm.ApproveObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.DeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.RelocateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.RemoveObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.SubmitObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.UndeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.lcm.UpdateObjectsRequest;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequest;
import org.oasis.ebxml.registry.bindings.query.ResponseOption;
import org.oasis.ebxml.registry.bindings.query.ResponseOptionType;
import org.oasis.ebxml.registry.bindings.query.ReturnType;
import org.oasis.ebxml.registry.bindings.rim.AdhocQuery;
import org.oasis.ebxml.registry.bindings.rim.AdhocQueryType;
import org.oasis.ebxml.registry.bindings.rim.Classification;
import org.oasis.ebxml.registry.bindings.rim.ClassificationNodeType;
import org.oasis.ebxml.registry.bindings.rim.ClassificationSchemeType;
import org.oasis.ebxml.registry.bindings.rim.Description;
import org.oasis.ebxml.registry.bindings.rim.IdentifiableType;
import org.oasis.ebxml.registry.bindings.rim.InternationalStringType;
import org.oasis.ebxml.registry.bindings.rim.LocalizedString;
import org.oasis.ebxml.registry.bindings.rim.LocalizedStringType;
import org.oasis.ebxml.registry.bindings.rim.Name;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefList;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefListType;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefType;
import org.oasis.ebxml.registry.bindings.rim.QueryExpressionType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectList;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectListType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.RegistryPackageType;
import org.oasis.ebxml.registry.bindings.rim.ServiceBindingType;
import org.oasis.ebxml.registry.bindings.rim.ServiceType;
import org.oasis.ebxml.registry.bindings.rim.Slot;
import org.oasis.ebxml.registry.bindings.rim.SlotListType;
import org.oasis.ebxml.registry.bindings.rim.SlotType1;
import org.oasis.ebxml.registry.bindings.rim.Value;
import org.oasis.ebxml.registry.bindings.rim.ValueList;
import org.oasis.ebxml.registry.bindings.rim.ValueListType;
import org.oasis.ebxml.registry.bindings.rs.RegistryRequestType;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponseType;
import org.oasis.saml.bindings.assertion.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BindingUtility
implements CanonicalConstants {
    public static final String ASSOCIATION_TYPE_ID_ProviderOf = "urn:oasis:names:tc:ebxml-regrep:AssociationType:ProviderOf";
    public static final String ASSOCIATION_TYPE_LID_ProviderOf = "urn:oasis:names:tc:ebxml-regrep:AssociationType:ProviderOf";
    public static final String ASSOCIATION_TYPE_CODE_ProviderOf = "ProviderOf";
    public static final String DEMO_DB_LID_PREFIX = "urn:freebxml:registry:demoDB:";
    public static final String FEDERATION_TEST_DATA_LID_PREFIX = "urn:freebxml:registry:demoDB:federation:";
    public static final String CPP_CLASSIFICATION_NODE_ID = "urn:uuid:2cad7eac-bc4d-42e8-9c98-d27982270496";
    public static final String FREEBXML_REGISTRY_ORGANIZATION_ID = "urn:freebxml:registry:Organization:freebXMLRegistry";
    private static BindingUtility instance = null;
    public org.oasis.ebxml.registry.bindings.rim.ObjectFactory rimFac;
    public org.oasis.ebxml.registry.bindings.rs.ObjectFactory rsFac;
    public org.oasis.ebxml.registry.bindings.lcm.ObjectFactory lcmFac;
    public org.oasis.ebxml.registry.bindings.query.ObjectFactory queryFac;
    public org.oasis.ebxml.registry.bindings.cms.ObjectFactory cmsFac;
    public org.oasis.saml.bindings.protocol.ObjectFactory samlProtocolFac;
    public ObjectFactory samlAssertionFac;
    JAXBContext jaxbContext = null;
    static /* synthetic */ Class class$org$freebxml$omar$common$BindingUtility;

    protected BindingUtility() {
        try {
            this.getJAXBContext();
            this.rimFac = new org.oasis.ebxml.registry.bindings.rim.ObjectFactory();
            this.rsFac = new org.oasis.ebxml.registry.bindings.rs.ObjectFactory();
            this.lcmFac = new org.oasis.ebxml.registry.bindings.lcm.ObjectFactory();
            this.queryFac = new org.oasis.ebxml.registry.bindings.query.ObjectFactory();
            this.cmsFac = new org.oasis.ebxml.registry.bindings.cms.ObjectFactory();
            this.samlProtocolFac = new org.oasis.saml.bindings.protocol.ObjectFactory();
            this.samlAssertionFac = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)"org.oasis.ebxml.registry.bindings.rim:org.oasis.ebxml.registry.bindings.rs:org.oasis.ebxml.registry.bindings.lcm:org.oasis.ebxml.registry.bindings.query:org.oasis.ebxml.registry.bindings.cms:org.oasis.saml.bindings.protocol:org.oasis.saml.bindings.assertion");
        }
        return this.jaxbContext;
    }

    public String getObjectTypeId(String rimClassName) throws JAXRException {
        String objectTypeId = null;
        try {
            Class<?> clazz = this.getClass();
            Field field = clazz.getField("CANONICAL_OBJECT_TYPE_ID_" + rimClassName);
            Object obj = field.get(this);
            objectTypeId = (String)obj;
        }
        catch (NoSuchFieldException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JAXRException((Throwable)e);
        }
        return objectTypeId;
    }

    public Map getRegistryObjectMap(Collection objs) throws JAXRException {
        HashMap<String, RegistryObjectType> map = new HashMap<String, RegistryObjectType>();
        if (objs != null) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof RegistryObjectType)) continue;
                RegistryObjectType ro = (RegistryObjectType)obj;
                map.put(ro.getId(), ro);
            }
        }
        return map;
    }

    public List getRegistryObjectList(RegistryObjectListType objs) throws JAXRException {
        ArrayList<IdentifiableType> al = new ArrayList<IdentifiableType>();
        if (objs != null) {
            List identifiables = objs.getIdentifiable();
            Iterator iter = identifiables.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                IdentifiableType identifiable = (IdentifiableType)obj;
                if (identifiable instanceof ObjectRefType) continue;
                al.add(identifiable);
            }
        }
        return al;
    }

    public void getObjectRefsAndRegistryObjects(RegistryObjectListType objs, Map objectsMap, Map orefMap) throws JAXRException {
        if (objs != null) {
            List identifiables = objs.getIdentifiable();
            Iterator iter = identifiables.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                IdentifiableType identifiable = (IdentifiableType)obj;
                if (identifiable instanceof RegistryObjectType) {
                    objectsMap.put(identifiable.getId(), identifiable);
                    continue;
                }
                if (!(identifiable instanceof ObjectRefType)) continue;
                orefMap.put(identifiable.getId(), identifiable);
            }
        }
    }

    public String getObjectId(Object obj) throws JAXRException {
        String id = null;
        if (obj != null) {
            if (obj instanceof ObjectRefType) {
                id = ((ObjectRefType)obj).getId();
            } else if (obj instanceof RegistryObjectType) {
                id = ((RegistryObjectType)obj).getId();
            } else if (obj instanceof String) {
                id = (String)obj;
            } else {
                throw new JAXRException("Unexpected object of type " + obj.getClass() + ". Expected String or ObjectRef or RegistryObjectType");
            }
        }
        return id;
    }

    public void setObjectId(Object obj, String id) throws JAXRException {
        if (obj != null) {
            if (obj instanceof ObjectRefType) {
                ((ObjectRefType)obj).setId(id);
            } else if (obj instanceof RegistryObjectType) {
                ((RegistryObjectType)obj).setId(id);
            } else {
                throw new JAXRException("Unexpected object of type " + obj.getClass() + ". Expected Object or ObjectRef or RegistryObjectType");
            }
        }
    }

    public String getRequestRootElement(InputStream request) throws JAXRException {
        String rootElementName = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(request);
            Element root = doc.getDocumentElement();
            rootElementName = root.getLocalName();
        }
        catch (IOException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JAXRException((Throwable)e);
        }
        return rootElementName;
    }

    public Object getRequestObject(File file) throws JAXRException {
        Object req = null;
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            req = unmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new JAXRException("Unable to Unmarshall request", (Throwable)e);
        }
        return req;
    }

    public Object getRequestObject(String rootElement, String message) throws JAXRException {
        Object req = null;
        try {
            StreamSource ss = new StreamSource(new StringReader(message));
            Unmarshaller unmarshaller = this.getUnmarshaller();
            req = unmarshaller.unmarshal((Source)ss);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new JAXRException("Unable to Unmarshall request", (Throwable)e);
        }
        return req;
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                boolean keepOn = false;
                return keepOn;
            }
        });
        return unmarshaller;
    }

    public StringBuffer getIdListFromRegistryObjects(List objs) {
        StringBuffer idList = new StringBuffer();
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            RegistryObjectType obj = (RegistryObjectType)iter.next();
            String id = obj.getId();
            idList.append("'" + id + "'");
            if (!iter.hasNext()) continue;
            idList.append(", ");
        }
        return idList;
    }

    public List getIdsFromRegistryObjects(Collection objs) {
        ArrayList<String> ids = new ArrayList<String>();
        if (objs.size() > 0) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                IdentifiableType ro = (IdentifiableType)iter.next();
                ids.add(ro.getId());
            }
        }
        return ids;
    }

    public List getObjectRefsFromRegistryObjects(List objs) throws JAXRException {
        ArrayList<ObjectRef> refs = new ArrayList<ObjectRef>();
        try {
            if (objs.size() > 0) {
                Iterator iter = objs.iterator();
                while (iter.hasNext()) {
                    IdentifiableType ro = (IdentifiableType)iter.next();
                    ObjectRef ref = this.rimFac.createObjectRef();
                    ref.setId(ro.getId());
                    refs.add(ref);
                }
            }
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return refs;
    }

    public List getObjectRefsFromRegistryObjectIds(List ids) throws JAXRException {
        ArrayList<ObjectRef> refs = new ArrayList<ObjectRef>();
        try {
            if (ids.size() > 0) {
                Iterator iter = ids.iterator();
                while (iter.hasNext()) {
                    ObjectRef ref = this.rimFac.createObjectRef();
                    ref.setId((String)iter.next());
                    refs.add(ref);
                }
            }
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return refs;
    }

    public List getRegistryObjectsFromIds(List objs, List ids) {
        ArrayList<RegistryObjectType> ros = new ArrayList<RegistryObjectType>();
        if (ids.size() > 0 && objs.size() > 0) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                RegistryObjectType ro = (RegistryObjectType)iter.next();
                if (!ids.contains(ro.getId())) continue;
                ros.add(ro);
            }
        }
        return ros;
    }

    public StringBuffer getIdListFromObjectRefList(ObjectRefList refList) {
        StringBuffer idList = new StringBuffer();
        List refs = refList.getObjectRef();
        Iterator iter = refs.iterator();
        int cnt = refs.size();
        int i = 0;
        while (iter.hasNext()) {
            ObjectRefType ref = (ObjectRefType)iter.next();
            String id = ref.getId();
            idList.append("'" + id + "'");
            if (i < cnt - 1) {
                idList.append(", ");
            }
            ++i;
        }
        return idList;
    }

    public StringBuffer getIdListFromIds(List ids) {
        StringBuffer idList = new StringBuffer();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            idList.append("'" + id + "'");
            if (!iter.hasNext()) continue;
            idList.append(",");
        }
        return idList;
    }

    public List getIdsFromObjectRefList(ObjectRefListType refList) {
        ArrayList<String> ids = new ArrayList<String>();
        List refs = refList.getObjectRef();
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            ObjectRefType ref = (ObjectRefType)iter.next();
            ids.add(ref.getId());
        }
        return ids;
    }

    public Object getObjectFromRequest(SubmitObjectsRequest registryRequest, String id) throws JAXRException {
        Object result = null;
        RegistryObjectListType objList = registryRequest.getRegistryObjectList();
        List objs = this.getRegistryObjectList(objList);
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            String objId = this.getObjectId(obj);
            if (!id.equalsIgnoreCase(objId)) continue;
            result = obj;
            break;
        }
        return result;
    }

    public List getIdsFromRequest(Object registryRequest) throws JAXRException {
        ArrayList ids = new ArrayList();
        if (!(registryRequest instanceof AdhocQueryRequest)) {
            if (registryRequest instanceof ApproveObjectsRequest) {
                ObjectRefListType refList = ((ApproveObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof DeprecateObjectsRequest) {
                ObjectRefListType refList = ((DeprecateObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof UndeprecateObjectsRequest) {
                ObjectRefListType refList = ((UndeprecateObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof RemoveObjectsRequest) {
                ObjectRefListType refList = ((RemoveObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof SubmitObjectsRequest) {
                RegistryObjectListType objList = ((SubmitObjectsRequest)registryRequest).getRegistryObjectList();
                List objs = this.getRegistryObjectList(objList);
                ids.addAll(this.getIdsFromRegistryObjects(objs));
            } else if (registryRequest instanceof UpdateObjectsRequest) {
                RegistryObjectListType objList = ((UpdateObjectsRequest)registryRequest).getRegistryObjectList();
                List objs = this.getRegistryObjectList(objList);
                ids.addAll(this.getIdsFromRegistryObjects(objs));
            } else if (!(registryRequest instanceof RelocateObjectsRequest)) {
                throw new JAXRException("InvalidRequest: Unknown request " + registryRequest.getClass().getName());
            }
        }
        return ids;
    }

    public Name getName(String name) throws JAXRException {
        Name internationalName = null;
        try {
            internationalName = BindingUtility.getInstance().rimFac.createName();
            LocalizedString ls = BindingUtility.getInstance().rimFac.createLocalizedString();
            ls.setValue(name);
            internationalName.getLocalizedString().add(ls);
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return internationalName;
    }

    public Description getDescription(String desc) throws JAXRException {
        Description internationalDesc = null;
        try {
            internationalDesc = BindingUtility.getInstance().rimFac.createDescription();
            LocalizedString ls = BindingUtility.getInstance().rimFac.createLocalizedString();
            ls.setValue(desc);
            internationalDesc.getLocalizedString().add(ls);
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return internationalDesc;
    }

    public String getInternationalStringAsString(InternationalStringType is) throws JAXRException {
        List localizedStrings = is.getLocalizedString();
        LocalizedStringType ls = (LocalizedStringType)localizedStrings.get(0);
        return ls.getValue();
    }

    public SOAPElement getSOAPElementFromBindingObject(Object obj) throws JAXRException {
        SOAPElement soapElem = null;
        try {
            SOAPElement parent = SOAPFactory.newInstance().createElement("dummy");
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal(obj, (Result)new DOMResult((Node)parent));
            soapElem = (SOAPElement)parent.getChildElements().next();
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        return soapElem;
    }

    public Object getBindingObjectFromSOAPElement(SOAPElement soapElem) throws JAXRException {
        Object obj = null;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            obj = unmarshaller.unmarshal((Node)soapElem);
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        return obj;
    }

    public void checkRegistryResponse(RegistryResponseType resp) throws JAXRException {
        if (!resp.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success")) {
            StringWriter sw = new StringWriter();
            try {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)resp, (Writer)sw);
                throw new JAXRException(sw.toString());
            }
            catch (Exception e) {
                throw new JAXRException((Throwable)e);
            }
        }
    }

    public Set getObjectRefsInRegistryObject(RegistryObjectType ro, Map idMap, Set processedObjects, int depth) throws JAXRException {
        HashSet refInfos = new HashSet();
        if (ro != null && !processedObjects.contains(ro)) {
            processedObjects.add(ro);
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.RegistryObjectType", refInfos, idMap, "ObjectType");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ClassificationNodeType", refInfos, idMap, "Parent");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ClassificationType", refInfos, idMap, "ClassificationNode");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ClassificationType", refInfos, idMap, "ClassificationScheme");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ClassificationType", refInfos, idMap, "ClassifiedObject");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ExternalIdentifierType", refInfos, idMap, "IdentificationScheme");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ExternalIdentifierType", refInfos, idMap, "RegistryObject");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.AssociationType1", refInfos, idMap, "AssociationType");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.AssociationType1", refInfos, idMap, "SourceObject");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.AssociationType1", refInfos, idMap, "TargetObject");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.AuditableEventType", refInfos, idMap, "User");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.AuditableEventType", refInfos, idMap, "RequestId");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.OrganizationType", refInfos, idMap, "Parent");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.RegistryType", refInfos, idMap, "Operator");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ServiceBindingType", refInfos, idMap, "Service");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.ServiceBindingType", refInfos, idMap, "TargetBinding");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.SpecificationLinkType", refInfos, idMap, "ServiceBinding");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.SpecificationLinkType", refInfos, idMap, "SpecificationObject");
            this.processRefAttribute(ro, "org.oasis.ebxml.registry.bindings.rim.SubscriptionType", refInfos, idMap, "Selector");
            if (--depth != 0) {
                Set composedObjects = this.getComposedRegistryObjects(ro, 1);
                Iterator iter = composedObjects.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof RegistryObjectType)) continue;
                    RegistryObjectType composedObject = (RegistryObjectType)obj;
                    Set composedRefInfos = this.getObjectRefsInRegistryObject(composedObject, idMap, processedObjects, depth);
                    refInfos.addAll(composedRefInfos);
                }
            }
        }
        return refInfos;
    }

    private void processRefAttribute(RegistryObjectType ro, String className, Set refInfos, Map idMap, String attribute) throws JAXRException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!clazz.isInstance(ro)) {
                return;
            }
            String getMethodName = "get" + attribute;
            Method getMethod = clazz.getMethod(getMethodName, null);
            String targetObjectId = (String)getMethod.invoke((Object)ro, (Object[])null);
            if (targetObjectId != null) {
                if (idMap.containsKey(targetObjectId)) {
                    targetObjectId = (String)idMap.get(targetObjectId);
                    Class[] parameterTypes = new Class[1];
                    Object[] parameterValues = new Object[1];
                    parameterTypes[0] = Class.forName("java.lang.String");
                    parameterValues[0] = targetObjectId;
                    String setMethodName = "set" + attribute;
                    Method setMethod = clazz.getMethod(setMethodName, parameterTypes);
                    setMethod.invoke((Object)ro, parameterValues);
                }
                ReferenceInfo refInfo = new ReferenceInfo(ro.getId(), targetObjectId, attribute);
                refInfos.add(refInfo);
            }
        }
        catch (Exception e) {
            System.err.println("Error: Class = " + ro.getClass() + " attribute = " + attribute);
            e.printStackTrace();
        }
    }

    public Set getComposedRegistryObjects(Collection registryObjects, int depth) {
        HashSet composedObjects = new HashSet();
        Iterator iter = registryObjects.iterator();
        while (iter.hasNext()) {
            RegistryObjectType ro = (RegistryObjectType)iter.next();
            composedObjects.addAll(this.getComposedRegistryObjects(ro, depth));
        }
        return composedObjects;
    }

    public Set getComposedRegistryObjects(RegistryObjectType ro, int depth) {
        HashSet<RegistryObjectType> composedObjects = new HashSet<RegistryObjectType>();
        if (ro != null) {
            ArrayList immediateComposedObjects = new ArrayList();
            immediateComposedObjects.addAll(ro.getClassification());
            immediateComposedObjects.addAll(ro.getExternalIdentifier());
            if (ro instanceof ClassificationNodeType) {
                ClassificationNodeType node = (ClassificationNodeType)ro;
                immediateComposedObjects.addAll(node.getClassificationNode());
            } else if (ro instanceof ClassificationSchemeType) {
                ClassificationSchemeType scheme = (ClassificationSchemeType)ro;
                immediateComposedObjects.addAll(scheme.getClassificationNode());
            } else if (ro instanceof ServiceBindingType) {
                ServiceBindingType binding = (ServiceBindingType)ro;
                immediateComposedObjects.addAll(binding.getSpecificationLink());
            } else if (ro instanceof RegistryPackageType) {
                RegistryPackageType pkg = (RegistryPackageType)ro;
                if (pkg.getRegistryObjectList() != null) {
                    immediateComposedObjects.addAll(pkg.getRegistryObjectList().getIdentifiable());
                }
            } else if (ro instanceof ServiceType) {
                ServiceType service = (ServiceType)ro;
                immediateComposedObjects.addAll(service.getServiceBinding());
            }
            --depth;
            Iterator iter = immediateComposedObjects.iterator();
            while (iter.hasNext()) {
                RegistryObjectType composedObject = (RegistryObjectType)iter.next();
                composedObjects.add(composedObject);
                if (depth == 0) continue;
                composedObjects.addAll(this.getComposedRegistryObjects(composedObject, depth));
            }
        }
        return composedObjects;
    }

    public String marshalObject(Object obj) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = BindingUtility.getInstance().rsFac.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(obj, (Writer)sw);
        String str = sw.toString();
        return str;
    }

    public void printObject(Object obj) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = BindingUtility.getInstance().rsFac.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(obj, (Writer)sw);
        String str = sw.toString();
        System.err.println(str);
    }

    public void addSlotsToRegistryObject(RegistryObjectType ro, Map slotsMap) throws JAXBException {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        Iterator iter = slotsMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object slotValue = slotsMap.get(key);
            Slot slot = BindingUtility.getInstance().rimFac.createSlot();
            slot.setName(key.toString());
            ValueList valueList = BindingUtility.getInstance().rimFac.createValueList();
            if (slotValue instanceof String) {
                Value value = BindingUtility.getInstance().rimFac.createValue();
                value.setValue(slotValue.toString());
                valueList.getValue().add(value);
            } else if (slotValue instanceof Collection) {
                Collection c = (Collection)slotValue;
                Iterator citer = c.iterator();
                while (citer.hasNext()) {
                    String str = citer.next().toString();
                    Value value = BindingUtility.getInstance().rimFac.createValue();
                    value.setValue(str);
                    valueList.getValue().add(value);
                }
            } else {
                throw new IllegalArgumentException("Adding a parameter of type " + slotValue.getClass().getName() + " to ValueImpl.setValue(String value) is not supported");
            }
            slot.setValueList((ValueListType)valueList);
            slots.add(slot);
        }
        ro.getSlot().addAll(slots);
    }

    public HashMap getSlotsFromRegistryObject(RegistryObjectType ro) throws JAXBException {
        HashMap<String, Object> slotsMap = new HashMap<String, Object>();
        List slots = ro.getSlot();
        if (slots == null) {
            return slotsMap;
        }
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            SlotType1 slot = (SlotType1)iter.next();
            String slotName = slot.getName();
            List values = slot.getValueList().getValue();
            String slotValue = null;
            if (values.size() == 1) {
                Value value = (Value)values.get(0);
                slotValue = value.getValue();
                slotsMap.put(slotName, slotValue);
                continue;
            }
            if (values.size() <= 1) continue;
            ArrayList<String> al = new ArrayList<String>();
            Iterator valuesIter = values.iterator();
            while (valuesIter.hasNext()) {
                Value value = (Value)valuesIter.next();
                String str = value.getValue();
                al.add(str);
            }
            slotsMap.put(slotName, al);
        }
        return slotsMap;
    }

    public void addSlotsToRequest(RegistryRequestType req, Map slotsMap) throws JAXBException {
        SlotListType slotList = req.getRequestSlotList();
        if (slotList == null) {
            slotList = BindingUtility.getInstance().rimFac.createSlotListType();
        }
        Iterator iter = slotsMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object slotValue = slotsMap.get(key);
            Slot slot = BindingUtility.getInstance().rimFac.createSlot();
            slot.setName(key.toString());
            ValueList valueList = BindingUtility.getInstance().rimFac.createValueList();
            if (slotValue instanceof String) {
                Value value = BindingUtility.getInstance().rimFac.createValue();
                value.setValue(slotValue.toString());
                valueList.getValue().add(value);
            } else if (slotValue instanceof Collection) {
                Collection c = (Collection)slotValue;
                Iterator citer = c.iterator();
                while (citer.hasNext()) {
                    String str = citer.next().toString();
                    Value value = BindingUtility.getInstance().rimFac.createValue();
                    value.setValue(str);
                    valueList.getValue().add(value);
                }
            } else {
                throw new IllegalArgumentException("Adding a parameter of type " + slotValue.getClass().getName() + " to ValueImpl.setValue(String value) is not supported");
            }
            slot.setValueList((ValueListType)valueList);
            slotList.getSlot().add(slot);
        }
        req.setRequestSlotList(slotList);
    }

    public HashMap getSlotsFromRequest(RegistryRequestType req) throws JAXBException {
        HashMap<String, Object> slotsMap = new HashMap<String, Object>();
        if (req != null) {
            SlotListType slotList = req.getRequestSlotList();
            if (slotList == null) {
                return slotsMap;
            }
            List slots = slotList.getSlot();
            Iterator iter = slots.iterator();
            while (iter.hasNext()) {
                SlotType1 slot = (SlotType1)iter.next();
                String slotName = slot.getName();
                List values = slot.getValueList().getValue();
                String slotValue = null;
                if (values.size() == 1) {
                    Value value = (Value)values.get(0);
                    slotValue = value.getValue();
                    slotsMap.put(slotName, slotValue);
                    continue;
                }
                if (values.size() <= 1) continue;
                ArrayList<String> al = new ArrayList<String>();
                Iterator valuesIter = values.iterator();
                while (valuesIter.hasNext()) {
                    Value value = (Value)valuesIter.next();
                    String str = value.getValue();
                    al.add(str);
                }
                slotsMap.put(slotName, al);
            }
        }
        return slotsMap;
    }

    public RegistryObjectType cloneRegistryObject(RegistryObjectType ro) throws JAXRException {
        RegistryObjectType roNew = null;
        try {
            StringWriter sw = new StringWriter();
            this.rimFac.createMarshaller().marshal((Object)ro, (Writer)sw);
            roNew = (RegistryObjectType)this.rimFac.createUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(sw.toString())));
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return roNew;
    }

    public InternationalStringType createInternationalStringType(String val) throws JAXRException {
        InternationalStringType is = null;
        try {
            is = this.rimFac.createInternationalStringType();
            LocalizedString ls = this.rimFac.createLocalizedString();
            ls.setValue(val);
            is.getLocalizedString().add(ls);
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return is;
    }

    public AdhocQueryRequest createAdhocQueryRequest(String queryStr) throws JAXBException {
        AdhocQueryRequest req = null;
        AdhocQuery adhocQuery = this.createAdhocQuery(queryStr);
        req = this.queryFac.createAdhocQueryRequest();
        req.setId(Utility.getInstance().createId());
        req.setAdhocQuery((AdhocQueryType)adhocQuery);
        ResponseOption ro = this.queryFac.createResponseOption();
        ro.setReturnComposedObjects(true);
        ro.setReturnType(ReturnType.LEAF_CLASS_WITH_REPOSITORY_ITEM);
        req.setResponseOption((ResponseOptionType)ro);
        return req;
    }

    public AdhocQuery createAdhocQuery(String queryStr) throws JAXBException {
        AdhocQuery adhocQuery = null;
        adhocQuery = this.rimFac.createAdhocQuery();
        adhocQuery.setId(Utility.getInstance().createId());
        QueryExpressionType queryExp = this.rimFac.createQueryExpressionType();
        adhocQuery.setQueryExpression(queryExp);
        queryExp.setQueryLanguage("urn:oasis:names:tc:ebxml-regrep:QueryLanguage:SQL-92");
        queryExp.getContent().add(queryStr);
        return adhocQuery;
    }

    public SubmitObjectsRequest createSubmitRequest(List ros) throws Exception {
        SubmitObjectsRequest request = this.lcmFac.createSubmitObjectsRequest();
        RegistryObjectList roList = this.rimFac.createRegistryObjectList();
        roList.getIdentifiable().addAll(ros);
        request.setRegistryObjectList((RegistryObjectListType)roList);
        return request;
    }

    public Classification createClassification(String classifiedObjectId, String classificationNodeId) throws JAXRException {
        Classification classification = null;
        try {
            classification = this.rimFac.createClassification();
            classification.setClassifiedObject(classifiedObjectId);
            classification.setClassificationNode(classificationNodeId);
        }
        catch (JAXBException e) {
            throw new JAXRException((Throwable)e);
        }
        return classification;
    }

    public void addClassificationToRegistryObject(RegistryObjectType ro, String classificationNodeId) throws JAXRException {
        Classification classification = this.createClassification(ro.getId(), classificationNodeId);
        ro.getClassification().add(classification);
    }

    public static String mapJAXRNameToEbXMLName(String className) {
        String newName = null;
        newName = className.equalsIgnoreCase("Concept") ? "ClassificationNode" : className;
        return newName;
    }

    public static String mapEbXMLNameToJAXRName(String ebXMLName) {
        String newName = null;
        newName = ebXMLName.equalsIgnoreCase("ClassificationNode") ? "Concept" : ebXMLName;
        return newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingUtility getInstance() {
        if (instance == null) {
            Class clazz = class$org$freebxml$omar$common$BindingUtility == null ? (class$org$freebxml$omar$common$BindingUtility = BindingUtility.class$("org.freebxml.omar.common.BindingUtility")) : class$org$freebxml$omar$common$BindingUtility;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new BindingUtility();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

