/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.freebxml.omar.common.security.KeyAliasSelectorResult;

public class X509KeySelector
extends KeySelector {
    private KeyStore keystore;

    public X509KeySelector(KeyStore keystore) {
        this.keystore = keystore;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        SignatureMethod sm = (SignatureMethod)method;
        List<XMLStructure> list = keyInfo.getContent();
        String alias = null;
        PublicKey pk = null;
        boolean trusted = false;
        boolean x509CertElementFound = false;
        for (int i = 0; i < list.size(); ++i) {
            XMLStructure xmlStructure = list.get(i);
            if (this.keystore != null && xmlStructure instanceof KeyName) {
                try {
                    alias = ((KeyName)xmlStructure).getName();
                    X509Certificate cert = (X509Certificate)this.keystore.getCertificate(alias);
                    if (cert == null) continue;
                    pk = cert.getPublicKey();
                    if (!X509KeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new KeyAliasSelectorResult(alias, pk, cert, false);
                }
                catch (KeyStoreException ke) {
                    throw new KeySelectorException(ke);
                }
            }
            if (xmlStructure instanceof KeyValue) {
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
                if (!X509KeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new KeyAliasSelectorResult(null, pk, null, false);
            }
            if (!(xmlStructure instanceof X509Data)) continue;
            try {
                List<?> x509DataList = ((X509Data)xmlStructure).getContent();
                Iterator<?> x509Iter = x509DataList.iterator();
                while (x509Iter.hasNext()) {
                    X509Certificate cert;
                    Object x509Item = x509Iter.next();
                    if (x509Item instanceof X509Certificate) {
                        cert = (X509Certificate)x509Item;
                        pk = cert.getPublicKey();
                        if (!X509KeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                        if (this.keystore != null) {
                            alias = this.keystore.getCertificateAlias((X509Certificate)x509Item);
                            if (alias != null) {
                                return new KeyAliasSelectorResult(alias, pk, cert, true);
                            }
                            return new KeyAliasSelectorResult(null, pk, cert, false);
                        }
                        return new KeyAliasSelectorResult(null, pk, cert, false);
                    }
                    if (this.keystore == null || !(x509Item instanceof String) || (cert = (X509Certificate)this.keystore.getCertificate(alias = (String)x509Item)) == null) continue;
                    pk = cert.getPublicKey();
                    if (!X509KeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new KeyAliasSelectorResult(alias, pk, cert, true);
                }
                continue;
            }
            catch (KeyStoreException ke) {
                throw new KeySelectorException(ke);
            }
        }
        throw new KeySelectorException("No supported key element found!");
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }
}

