/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.wrappers;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;

public class TckConnectionWrapper
implements Connection {
    private static final int GET_TX_ISOLATION = 0;
    private static final int SET_AUTOCOMMIT = 1;
    private static final int SET_TX_ISOLATION = 2;
    private static final int COMMIT_ROLLBACK = 3;
    private static final int RESET_TX_ISOLATION = 4;
    private static final int RESET_AUTOCOMMIT = 5;
    private static final int CLOSE_CONNECTION = 6;
    private static final int MAXLIFECYCLE_SIZE = 7;
    private ServletContext _context = null;
    private Connection _conn = null;
    private ArrayList _log = null;
    private int _autoCommitMode;
    private boolean _setIsolationLevel = false;
    private boolean _resetIsolationLevel = false;
    private int _newIsolationSetting = -1;

    public TckConnectionWrapper(ServletContext context, Connection conn) {
        this._context = context;
        this._conn = conn;
        this._log = new ArrayList(7);
        for (int i = 0; i < 7; ++i) {
            this._log.add(i, "");
        }
        this._setIsolationLevel = false;
        this._resetIsolationLevel = false;
        this._autoCommitMode = 1;
        int isoLevel = 0;
        try {
            isoLevel = conn.getTransactionIsolation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer newIsoLevel = (Integer)context.getAttribute("isoLevel");
        this._newIsolationSetting = newIsoLevel != null ? newIsoLevel : isoLevel;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this._log.set(6, "Connection.close()");
        ArrayList<String> lifeCycle = new ArrayList<String>();
        for (String buf : this._log) {
            if (buf.equals("")) continue;
            lifeCycle.add(buf);
        }
        this._context.setAttribute("connLog", lifeCycle);
        this._conn.close();
    }

    @Override
    public void commit() throws SQLException {
        this._log.set(3, "Connection.commit()");
        this._conn.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this._conn.createStatement();
    }

    @Override
    public Statement createStatement(int param, int param1) throws SQLException {
        return this._conn.createStatement(param, param1);
    }

    @Override
    public Statement createStatement(int param, int param1, int param2) throws SQLException {
        return this._conn.createStatement(param, param1, param2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this._conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this._log.set(0, "Connection.getTransactionIsolation()");
        int isolationSetting = this._conn.getTransactionIsolation();
        return isolationSetting;
    }

    public Map getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String str) throws SQLException {
        return this._conn.nativeSQL(str);
    }

    @Override
    public CallableStatement prepareCall(String str) throws SQLException {
        return this._conn.prepareCall(str);
    }

    @Override
    public CallableStatement prepareCall(String str, int param, int param2) throws SQLException {
        return this._conn.prepareCall(str, param, param2);
    }

    @Override
    public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
        return this._conn.prepareCall(str, param, param2, param3);
    }

    @Override
    public PreparedStatement prepareStatement(String str) throws SQLException {
        return this._conn.prepareStatement(str);
    }

    @Override
    public PreparedStatement prepareStatement(String str, int param) throws SQLException {
        return this._conn.prepareStatement(str, param);
    }

    @Override
    public PreparedStatement prepareStatement(String str, int[] values) throws SQLException {
        return this._conn.prepareStatement(str, values);
    }

    @Override
    public PreparedStatement prepareStatement(String str, String[] str1) throws SQLException {
        return this._conn.prepareStatement(str, str1);
    }

    @Override
    public PreparedStatement prepareStatement(String str, int param, int param2) throws SQLException {
        return this._conn.prepareStatement(str, param, param2);
    }

    @Override
    public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
        return this._conn.prepareStatement(str, param, param2, param3);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this._log.set(3, "Connection.rollback()");
        this._conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean param) throws SQLException {
        this._log.set(this._autoCommitMode, "Connection.setAutoCommit(" + param + ")");
        this._conn.setAutoCommit(param);
        this._autoCommitMode = 5;
    }

    @Override
    public void setCatalog(String str) throws SQLException {
        this._conn.setCatalog(str);
    }

    @Override
    public void setHoldability(int param) throws SQLException {
        this._conn.setHoldability(param);
    }

    @Override
    public void setReadOnly(boolean param) throws SQLException {
        this._conn.setReadOnly(param);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String str) throws SQLException {
        return this._conn.setSavepoint(str);
    }

    @Override
    public void setTransactionIsolation(int param) throws SQLException {
        if (!this._setIsolationLevel) {
            this.setTransactionIsolationSetting(2, param);
            this._setIsolationLevel = true;
        } else if (!this._resetIsolationLevel) {
            this.setTransactionIsolationSetting(4, param);
            this._resetIsolationLevel = true;
        }
        this._conn.setTransactionIsolation(param);
    }

    public void setTypeMap(Map map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    private void setTransactionIsolationSetting(int slot, int param) {
        String isolationLevel = null;
        switch (param) {
            case 1: {
                isolationLevel = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 2: {
                isolationLevel = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 4: {
                isolationLevel = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                isolationLevel = "TRANSACTION_SERIALIZABLE";
            }
        }
        if (slot == 4) {
            isolationLevel = "";
        }
        this._log.set(slot, "Connection.setTransactionIsolation(" + isolationLevel + ")");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }
}

